/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xml.stream;

import aavax.xml.namespace.NamespaceContext;
import aavax.xml.namespace.QName;
import aavax.xml.stream.Location;
import aavax.xml.stream.XMLOutputFactory;
import aavax.xml.stream.XMLStreamException;
import aavax.xml.stream.XMLStreamReader;
import aavax.xml.stream.XMLStreamWriter;
import aavax.xml.stream.events.Attribute;
import com.bea.xml.stream.EventScanner;
import com.bea.xml.stream.EventState;
import com.bea.xml.stream.ReaderToWriter;
import com.bea.xml.stream.util.NamespaceContextImpl;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class XMLStreamPlayer
implements XMLStreamReader {
    EventState state;
    EventScanner scanner;
    NamespaceContextImpl context = new NamespaceContextImpl();

    public XMLStreamPlayer() {
    }

    public XMLStreamPlayer(InputStream stream) {
        try {
            this.scanner = new EventScanner(new InputStreamReader(stream));
            this.next();
            if (this.getEventType() == 7) {
                String encoding = this.getCharacterEncodingScheme();
                this.scanner = new EventScanner(new InputStreamReader(stream, encoding));
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to instantiate the XMLStreamPlayer" + e.getMessage());
        }
    }

    public XMLStreamPlayer(Reader reader) {
        try {
            this.scanner = new EventScanner(reader);
            this.next();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public Object getProperty(String name) throws IllegalArgumentException {
        return null;
    }

    public int next() throws XMLStreamException {
        try {
            if (!this.scanner.hasNext()) {
                this.state = null;
                return -1;
            }
            this.state = this.scanner.readElement();
            if (this.isStartElement()) {
                this.context.openScope();
                for (int i = 0; i < this.getNamespaceCount(); ++i) {
                    this.context.bindNamespace(this.getNamespacePrefix(i), this.getNamespaceURI(i));
                }
            } else if (this.isEndElement() && this.context.getDepth() > 0) {
                this.context.closeScope();
            }
            return this.state.getType();
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
            throw new XMLStreamException(e.getMessage(), e);
        }
    }

    public void require(int type, String namespaceURI, String localName) throws XMLStreamException {
    }

    public String getElementText() throws XMLStreamException {
        StringBuffer buf = new StringBuffer();
        if (this.getEventType() != 1) {
            throw new XMLStreamException("Precondition for readText is getEventType() == START_ELEMENT");
        }
        do {
            if (this.next() == 8) {
                throw new XMLStreamException("Unexpected end of Document");
            }
            if (this.isStartElement()) {
                throw new XMLStreamException("Unexpected Element start");
            }
            if (!this.isCharacters()) continue;
            buf.append(this.getText());
        } while (!this.isEndElement());
        return buf.toString();
    }

    public int nextTag() throws XMLStreamException {
        do {
            if (this.next() == 8) {
                throw new XMLStreamException("Unexpected end of Document");
            }
            if (!this.isCharacters() || this.isWhiteSpace()) continue;
            throw new XMLStreamException("Unexpected text");
        } while (!this.isStartElement() && !this.isEndElement());
        return this.getEventType();
    }

    public boolean hasNext() throws XMLStreamException {
        try {
            return this.state != null && this.state.getType() != 8;
        }
        catch (Exception e) {
            throw new XMLStreamException(e);
        }
    }

    public void close() throws XMLStreamException {
    }

    public String getNamespaceURI(String prefix) {
        return this.context.getNamespaceURI(prefix);
    }

    private Attribute getAttributeInternal(int index) {
        return (Attribute)this.state.getAttributes().get(index);
    }

    private Attribute getNamespaceInternal(int index) {
        return (Attribute)this.state.getNamespaces().get(index);
    }

    public boolean isStartElement() {
        return (this.getEventType() & 1) != 0;
    }

    public boolean isEndElement() {
        return (this.getEventType() & 2) != 0;
    }

    public boolean isCharacters() {
        return (this.getEventType() & 4) != 0;
    }

    public boolean isWhiteSpace() {
        return false;
    }

    public String getAttributeValue(String namespaceUri, String localName) {
        for (int i = 0; i < this.getAttributeCount(); ++i) {
            Attribute a = this.getAttributeInternal(i);
            if (!localName.equals(a.getName().getLocalPart())) continue;
            if (namespaceUri == null) {
                return a.getValue();
            }
            if (!namespaceUri.equals(a.getName().getNamespaceURI())) continue;
            return a.getValue();
        }
        return null;
    }

    public int getAttributeCount() {
        if (this.isStartElement()) {
            return this.state.getAttributes().size();
        }
        return 0;
    }

    public QName getAttributeName(int index) {
        return new QName(this.getAttributeNamespace(index), this.getAttributeLocalName(index), this.getAttributePrefix(index));
    }

    public String getAttributeNamespace(int index) {
        Attribute a = this.getAttributeInternal(index);
        if (a == null) {
            return null;
        }
        return a.getName().getNamespaceURI();
    }

    public String getAttributeLocalName(int index) {
        Attribute a = this.getAttributeInternal(index);
        if (a == null) {
            return null;
        }
        return a.getName().getLocalPart();
    }

    public String getAttributePrefix(int index) {
        Attribute a = this.getAttributeInternal(index);
        if (a == null) {
            return null;
        }
        return a.getName().getPrefix();
    }

    public String getAttributeType(int index) {
        return "CDATA";
    }

    public String getAttributeValue(int index) {
        Attribute a = this.getAttributeInternal(index);
        if (a == null) {
            return null;
        }
        return a.getValue();
    }

    public boolean isAttributeSpecified(int index) {
        return false;
    }

    public int getNamespaceCount() {
        if (this.isStartElement()) {
            return this.state.getNamespaces().size();
        }
        return 0;
    }

    public String getNamespacePrefix(int index) {
        Attribute a = this.getNamespaceInternal(index);
        if (a == null) {
            return null;
        }
        return a.getName().getLocalPart();
    }

    public String getNamespaceURI(int index) {
        Attribute a = this.getNamespaceInternal(index);
        if (a == null) {
            return null;
        }
        return a.getValue();
    }

    public NamespaceContext getNamespaceContext() {
        return this.context;
    }

    public XMLStreamReader subReader() throws XMLStreamException {
        return null;
    }

    public int getEventType() {
        if (this.state == null) {
            return 8;
        }
        return this.state.getType();
    }

    public String getText() {
        return this.state.getData();
    }

    public Reader getTextStream() {
        throw new UnsupportedOperationException();
    }

    public char[] getTextCharacters() {
        return this.state.getData().toCharArray();
    }

    public int getTextCharacters(int src, char[] target, int targetStart, int length) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    public int getTextStart() {
        return 0;
    }

    public int getTextLength() {
        return this.state.getData().length();
    }

    public String getEncoding() {
        return this.state.getData();
    }

    public boolean hasText() {
        return 0 != (this.getEventType() & 0xF);
    }

    public Location getLocation() {
        return null;
    }

    public QName getName() {
        return new QName(this.getNamespaceURI(), this.getLocalName(), this.getPrefix());
    }

    public String getLocalName() {
        return this.state.getLocalName();
    }

    public boolean hasName() {
        return 0 != (this.getEventType() & 0xB);
    }

    public String getNamespaceURI() {
        return this.state.getNamespaceURI();
    }

    public String getPrefix() {
        return this.state.getPrefix();
    }

    public String getVersion() {
        return "1.0";
    }

    public boolean isStandalone() {
        return true;
    }

    public boolean standaloneSet() {
        return false;
    }

    public String getCharacterEncodingScheme() {
        return null;
    }

    public String getPITarget() {
        return this.state.getData();
    }

    public String getPIData() {
        return this.state.getExtraData();
    }

    public boolean endDocumentIsPresent() {
        return this.scanner.endDocumentIsPresent();
    }

    public static void main(String[] args) throws Exception {
        XMLStreamPlayer reader = new XMLStreamPlayer(new FileReader(args[0]));
        XMLOutputFactory xmlof = XMLOutputFactory.newInstance();
        XMLStreamWriter xmlw = xmlof.createXMLStreamWriter(System.out);
        ReaderToWriter rtow = new ReaderToWriter(xmlw);
        while (reader.hasNext()) {
            rtow.write(reader);
            reader.next();
        }
        xmlw.flush();
    }
}

