/*
 * Decompiled with CFR 0.152.
 */
package com.lidroid.xutils.util;

import android.text.TextUtils;
import com.lidroid.xutils.util.CharsetUtils;
import com.lidroid.xutils.util.LogUtils;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.conn.ssl.SSLSocketFactory;

public class OtherUtils {
    private static final int STRING_BUFFER_LENGTH = 100;
    private static TrustManager[] trustAllCerts;

    private OtherUtils() {
    }

    public static boolean isSupportRange(HttpResponse response) {
        if (response == null) {
            return false;
        }
        Header header = response.getFirstHeader("Accept-Ranges");
        if (header != null) {
            return "bytes".equals(header.getValue());
        }
        header = response.getFirstHeader("Content-Range");
        if (header != null) {
            String value = header.getValue();
            return value != null && value.startsWith("bytes");
        }
        return false;
    }

    public static String getFileNameFromHttpResponse(HttpResponse response) {
        if (response == null) {
            return null;
        }
        String result = null;
        Header header = response.getFirstHeader("Content-Disposition");
        if (header != null) {
            HeaderElement[] headerElementArray = header.getElements();
            int n = headerElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                HeaderElement element = headerElementArray[n2];
                NameValuePair fileNamePair = element.getParameterByName("filename");
                if (fileNamePair != null) {
                    result = fileNamePair.getValue();
                    result = CharsetUtils.toCharset(result, "UTF-8", result.length());
                    break;
                }
                ++n2;
            }
        }
        return result;
    }

    public static Charset getCharsetFromHttpRequest(HttpRequestBase request) {
        if (request == null) {
            return null;
        }
        String charsetName = null;
        Header header = request.getFirstHeader("Content-Type");
        if (header != null) {
            HeaderElement[] headerElementArray = header.getElements();
            int n = headerElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                HeaderElement element = headerElementArray[n2];
                NameValuePair charsetPair = element.getParameterByName("charset");
                if (charsetPair != null) {
                    charsetName = charsetPair.getValue();
                    break;
                }
                ++n2;
            }
        }
        boolean isSupportedCharset = false;
        if (!TextUtils.isEmpty(charsetName)) {
            try {
                isSupportedCharset = Charset.isSupported(charsetName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return isSupportedCharset ? Charset.forName(charsetName) : null;
    }

    public static long sizeOfString(String str, String charset) throws UnsupportedEncodingException {
        if (TextUtils.isEmpty((CharSequence)str)) {
            return 0L;
        }
        int len = str.length();
        if (len < 100) {
            return str.getBytes(charset).length;
        }
        long size = 0L;
        int i = 0;
        while (i < len) {
            int end = i + 100;
            end = end < len ? end : len;
            String temp = OtherUtils.getSubString(str, i, end);
            size += (long)temp.getBytes(charset).length;
            i += 100;
        }
        return size;
    }

    public static String getSubString(String str, int start, int end) {
        return new String(str.substring(start, end));
    }

    public static StackTraceElement getCurrentStackTraceElement() {
        return Thread.currentThread().getStackTrace()[3];
    }

    public static StackTraceElement getCallerStackTraceElement() {
        return Thread.currentThread().getStackTrace()[4];
    }

    public static void trustAllSSLForHttpsURLConnection() {
        if (trustAllCerts == null) {
            trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
        }
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustAllCerts, null);
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
        }
        catch (Throwable e) {
            LogUtils.e(e.getMessage(), e);
        }
        HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
    }
}

