/*
 * Decompiled with CFR 0.152.
 */
package com.lidroid.xutils.http.client.multipart;

import com.lidroid.xutils.http.client.multipart.MinimalField;
import com.lidroid.xutils.http.client.multipart.MinimalFieldHeader;
import com.lidroid.xutils.http.client.multipart.content.ContentBody;

public class FormBodyPart {
    private final String name;
    private final MinimalFieldHeader header;
    private final ContentBody body;

    public FormBodyPart(String name, ContentBody body) {
        if (name == null) {
            throw new IllegalArgumentException("Name may not be null");
        }
        if (body == null) {
            throw new IllegalArgumentException("Body may not be null");
        }
        this.name = name;
        this.body = body;
        this.header = new MinimalFieldHeader();
        this.generateContentDisposition(body);
        this.generateContentType(body);
        this.generateTransferEncoding(body);
    }

    public FormBodyPart(String name, ContentBody body, String contentDisposition) {
        if (name == null) {
            throw new IllegalArgumentException("Name may not be null");
        }
        if (body == null) {
            throw new IllegalArgumentException("Body may not be null");
        }
        this.name = name;
        this.body = body;
        this.header = new MinimalFieldHeader();
        if (contentDisposition != null) {
            this.addField("Content-Disposition", contentDisposition);
        } else {
            this.generateContentDisposition(body);
        }
        this.generateContentType(body);
        this.generateTransferEncoding(body);
    }

    public String getName() {
        return this.name;
    }

    public ContentBody getBody() {
        return this.body;
    }

    public MinimalFieldHeader getHeader() {
        return this.header;
    }

    public void addField(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Field name may not be null");
        }
        this.header.addField(new MinimalField(name, value));
    }

    protected void generateContentDisposition(ContentBody body) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("form-data; name=\"");
        buffer.append(this.getName());
        buffer.append("\"");
        if (body.getFilename() != null) {
            buffer.append("; filename=\"");
            buffer.append(body.getFilename());
            buffer.append("\"");
        }
        this.addField("Content-Disposition", buffer.toString());
    }

    protected void generateContentType(ContentBody body) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(body.getMimeType());
        if (body.getCharset() != null) {
            buffer.append("; charset=");
            buffer.append(body.getCharset());
        }
        this.addField("Content-Type", buffer.toString());
    }

    protected void generateTransferEncoding(ContentBody body) {
        this.addField("Content-Transfer-Encoding", body.getTransferEncoding());
    }
}

