/*
 * Decompiled with CFR 0.152.
 */
package com.lidroid.xutils.http.client.entity;

import com.lidroid.xutils.http.callback.RequestCallBackHandler;
import com.lidroid.xutils.http.client.entity.UploadEntity;
import com.lidroid.xutils.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import org.apache.http.entity.AbstractHttpEntity;

public class InputStreamUploadEntity
extends AbstractHttpEntity
implements UploadEntity {
    private static final int BUFFER_SIZE = 2048;
    private final InputStream content;
    private final long length;
    private long uploadedSize = 0L;
    private RequestCallBackHandler callBackHandler = null;

    public InputStreamUploadEntity(InputStream inputStream, long length) {
        if (inputStream == null) {
            throw new IllegalArgumentException("Source input stream may not be null");
        }
        this.content = inputStream;
        this.length = length;
    }

    public boolean isRepeatable() {
        return false;
    }

    public long getContentLength() {
        return this.length;
    }

    public InputStream getContent() throws IOException {
        return this.content;
    }

    public void writeTo(OutputStream outStream) throws IOException {
        if (outStream == null) {
            throw new IllegalArgumentException("Output stream may not be null");
        }
        InputStream inStream = this.content;
        try {
            byte[] buffer = new byte[2048];
            if (this.length < 0L) {
                int l;
                while ((l = inStream.read(buffer)) != -1) {
                    outStream.write(buffer, 0, l);
                    this.uploadedSize += (long)l;
                    if (this.callBackHandler == null || this.callBackHandler.updateProgress(this.uploadedSize + 1L, this.uploadedSize, false)) continue;
                    throw new InterruptedIOException("stop");
                }
            } else {
                long remaining = this.length;
                while (remaining > 0L) {
                    int l = inStream.read(buffer, 0, (int)Math.min(2048L, remaining));
                    if (l != -1) {
                        outStream.write(buffer, 0, l);
                        remaining -= (long)l;
                        this.uploadedSize += (long)l;
                        if (this.callBackHandler == null || this.callBackHandler.updateProgress(this.length, this.uploadedSize, false)) continue;
                        throw new InterruptedIOException("stop");
                    }
                    break;
                }
            }
            outStream.flush();
            if (this.callBackHandler != null) {
                this.callBackHandler.updateProgress(this.length, this.uploadedSize, true);
            }
        }
        finally {
            IOUtils.closeQuietly(inStream);
        }
    }

    public boolean isStreaming() {
        return true;
    }

    public void consumeContent() throws IOException {
        this.content.close();
    }

    @Override
    public void setCallBackHandler(RequestCallBackHandler callBackHandler) {
        this.callBackHandler = callBackHandler;
    }
}

