/*
 * Decompiled with CFR 0.152.
 */
package com.lidroid.xutils.http.client.entity;

import com.lidroid.xutils.http.callback.RequestCallBackHandler;
import com.lidroid.xutils.http.client.entity.UploadEntity;
import com.lidroid.xutils.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.entity.HttpEntityWrapper;

abstract class DecompressingEntity
extends HttpEntityWrapper
implements UploadEntity {
    private InputStream content;
    private long uncompressedLength;
    private long uploadedSize = 0L;
    private RequestCallBackHandler callBackHandler = null;

    public DecompressingEntity(HttpEntity wrapped) {
        super(wrapped);
        this.uncompressedLength = wrapped.getContentLength();
    }

    abstract InputStream decorate(InputStream var1) throws IOException;

    private InputStream getDecompressingStream() throws IOException {
        InputStream in = null;
        try {
            in = this.wrappedEntity.getContent();
            return this.decorate(in);
        }
        catch (IOException ex) {
            IOUtils.closeQuietly(in);
            throw ex;
        }
    }

    public InputStream getContent() throws IOException {
        if (this.wrappedEntity.isStreaming()) {
            if (this.content == null) {
                this.content = this.getDecompressingStream();
            }
            return this.content;
        }
        return this.getDecompressingStream();
    }

    public long getContentLength() {
        return -1L;
    }

    public void writeTo(OutputStream outStream) throws IOException {
        if (outStream == null) {
            throw new IllegalArgumentException("Output stream may not be null");
        }
        InputStream inStream = null;
        try {
            int len;
            inStream = this.getContent();
            byte[] tmp = new byte[4096];
            while ((len = inStream.read(tmp)) != -1) {
                outStream.write(tmp, 0, len);
                this.uploadedSize += (long)len;
                if (this.callBackHandler == null || this.callBackHandler.updateProgress(this.uncompressedLength, this.uploadedSize, false)) continue;
                throw new InterruptedIOException("stop");
            }
            outStream.flush();
            if (this.callBackHandler != null) {
                this.callBackHandler.updateProgress(this.uncompressedLength, this.uploadedSize, true);
            }
        }
        finally {
            IOUtils.closeQuietly(inStream);
        }
    }

    @Override
    public void setCallBackHandler(RequestCallBackHandler callBackHandler) {
        this.callBackHandler = callBackHandler;
    }
}

