#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<errno.h>
#include "sdk_common_api.h"
#include "zpl_sdk_api.h"



void test_zpl()
{
    void *phandle = NULL;
    int result = 0;
    int status = 0; 
    char error_msg[1024] = {0};
    char cName[128] = {0};
    char cFonts[128] = {0};

    result = PrinterCreator(&phandle, "HM-T300 PRO");

    if (0 != result)
    {
        FormatError(result, 0, (unsigned char*)error_msg, 0, sizeof(error_msg));
        printf("%s\n", error_msg);
        return;
    }

    result = PortOpen(phandle, "USB,HM-T300 PRO,vid=0x20D1,pid=0x4000");
    if (0 != result)
    {
        FormatError(result, 0, (unsigned char*)error_msg, 0, sizeof(error_msg));
        printf("%s\n", error_msg);
    }
    else
    {
	result = ZPL_GetPrinterName(phandle, cName);
	printf("PrinterName = %s\n", cName);
	result = ZPL_GetPrinterFonts(phandle, cFonts);
	printf("PrinterFonts = %s\n", cFonts);
	result = ZPL_GetPrinterStatus(phandle,&status);
	printf("status = %d\n", status);
        //开始
        result = ZPL_StartFormat(phandle);
	
	result = ZPL_SetPrinterNetMode(phandle, 2);
        result = ZPL_SetPrinterNetSSID(phandle, 2, "HM-T300 Pro");
        result = ZPL_SetPrinterNetPwdSwitch(phandle, 1);
        result = ZPL_SetPrinterNetPwd(phandle, 2, "12345678");
        result = ZPL_SetPrinterNetDHCP(phandle, 1);
        result = ZPL_SetPrintIpAddress(phandle, 2, "192.168.1.2");
        result = ZPL_SetPrintSubnetMask(phandle, "255.255.255.1");
        result = ZPL_SetPrintDefaultGateway(phandle, "192.168.1.2");
        result = ZPL_SetPrinterBluetoothSSID(phandle, "Bluetooth SSID");
        result = ZPL_SetPrinterBluetoothPIN(phandle, "12345678");
        result = ZPL_SetPrinterSleepTime(phandle, 5);
        result = ZPL_SetPrinterShutdownTime(phandle, 360);
        //设置打印浓度
        result = ZPL_SetPrintDarkness(phandle, 20);
        //设置是否翻转打印
        result = ZPL_SetPrintOrientation(phandle,0);
        //打印图片
        result = ZPL_PrintImage(phandle, 100, 30, "/home/liu/Documents/1-x.bmp");
        //打印Pdf417
        result = ZPL_Pdf417(phandle, 100, 150, 0, 2, 20, 2, 5, 5, 'N', "0010101101");
        //打印CodeEan8条码
        result = ZPL_CodeEan8(phandle, 100, 300, 0, 3, 60, 'Y', 'Y', "90381010");
        //打印BarCode39条码
        result = ZPL_BarCode39(phandle, 100, 450, 0, 3, 50, 'Y', 'Y', 'Y', "66886868");
        //打印UPC-A
        result = ZPL_UpcaBarcode(phandle, 100, 600, 0, 3, 50, 'Y', 'Y', 'N', "47631664454");
        //打印UPC扩展条码
        result = ZPL_UpcExtensions(phandle, 100, 700, 0, 3, 50, 'Y', 'Y', "01234");
        //打印二维码
        result = ZPL_QRCode(phandle, 100, 800, 0, 1, 3, 'M','M','N', "1000000001");
        //打印text
        result = ZPL_Text(phandle, 100, 900, 16, 0, 40, 40, "hello");
        //打印图形圆圈
        result = ZPL_GraphicCircle(phandle, 100, 1000, 150, 5);
        //打印图形椭圆
        result = ZPL_GraphicEllipse(phandle, 300, 1000, 150, 100, 10);
        //打印对角线
        result = ZPL_GraphicDiagonalLine(phandle, 500, 1000, 0x52, 50, 50, 20);
        //打印图形框
        result = ZPL_GraphicBox(phandle, 100, 1200, 100, 100, 60, 3);
        //打印符号
        result = ZPL_GraphicSymbol(phandle, 300, 1200, 0, 200, 200, "A");
        //结束
        result = ZPL_EndFormat(phandle);
	
    }
    //删除打印机
    result = PortClose(phandle);
    //销毁
    result = PrinterDestroy(phandle);

    //result = ZPL_FontDownload(phandle, "T300PRO_font_V1.1.1.prtf","HM-T300 PRO","USB,HM-T300 PRO,vid=0x20D1,pid=0x4000");
    //result = ZPL_VectorFontDownload(phandle, "LCALLIG.TTF","HM-T300 PRO","USB,HM-T300 PRO,vid=0x20D1,pid=0x4000");
    //result = ZPL_FirmwareUpgrade(phandle,"HM-T300PRO_V1.2.21_04_Beta1.bin","HM-T300 PRO","USB,HM-T300 PRO,vid=0x20D1,pid=0x4000");
}

int main()
{
    test_zpl();
    return 0;
}
