/*
 * Decompiled with CFR 0.152.
 */
package com.lidroid.xutils.http.client.multipart.content;

import com.lidroid.xutils.http.client.multipart.content.AbstractContentBody;
import java.io.IOException;
import java.io.OutputStream;

public class ByteArrayBody
extends AbstractContentBody {
    private final byte[] data;
    private final String filename;

    public ByteArrayBody(byte[] data, String mimeType, String filename) {
        super(mimeType);
        if (data == null) {
            throw new IllegalArgumentException("byte[] may not be null");
        }
        this.data = data;
        this.filename = filename;
    }

    public ByteArrayBody(byte[] data, String filename) {
        this(data, "application/octet-stream", filename);
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        out.write(this.data);
        this.callBackInfo.pos += (long)this.data.length;
        this.callBackInfo.doCallBack(false);
    }

    @Override
    public String getCharset() {
        return null;
    }

    @Override
    public String getTransferEncoding() {
        return "binary";
    }

    @Override
    public long getContentLength() {
        return this.data.length;
    }
}

