/*
 * Decompiled with CFR 0.152.
 */
package com.lidroid.xutils.util.core;

import com.lidroid.xutils.util.IOUtils;
import com.lidroid.xutils.util.LogUtils;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class LruDiskCache
implements Closeable {
    static final String JOURNAL_FILE = "journal";
    static final String JOURNAL_FILE_TEMP = "journal.tmp";
    static final String JOURNAL_FILE_BACKUP = "journal.bkp";
    static final String MAGIC = "libcore.io.DiskLruCache";
    static final String VERSION_1 = "1";
    static final long ANY_SEQUENCE_NUMBER = -1L;
    static final Pattern LEGAL_KEY_PATTERN = Pattern.compile("[a-z0-9_-]{1,64}");
    private static final String CLEAN = "CLEAN";
    private static final String DIRTY = "DIRTY";
    private static final String REMOVE = "REMOVE";
    private static final String READ = "READ";
    private final File directory;
    private final File journalFile;
    private final File journalFileTmp;
    private final File journalFileBackup;
    private final int appVersion;
    private long maxSize;
    private final int valueCount;
    private long size = 0L;
    private Writer journalWriter;
    private final LinkedHashMap<String, Entry> lruEntries = new LinkedHashMap(0, 0.75f, true);
    private int redundantOpCount;
    private long nextSequenceNumber = 0L;
    final ThreadPoolExecutor executorService = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private final Callable<Void> cleanupCallable = new Callable<Void>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            LruDiskCache lruDiskCache = LruDiskCache.this;
            synchronized (lruDiskCache) {
                block5: {
                    if (LruDiskCache.this.journalWriter != null) break block5;
                    return null;
                }
                LruDiskCache.this.trimToSize();
                if (LruDiskCache.this.journalRebuildRequired()) {
                    LruDiskCache.this.rebuildJournal();
                    LruDiskCache.this.redundantOpCount = 0;
                }
            }
            return null;
        }
    };
    private static final OutputStream NULL_OUTPUT_STREAM = new OutputStream(){

        @Override
        public void write(int b) throws IOException {
        }
    };
    private DiskCacheFileNameGenerator diskCacheFileNameGenerator = new MD5DiskCacheFileNameGenerator();

    private LruDiskCache(File directory, int appVersion, int valueCount, long maxSize) {
        this.directory = directory;
        this.appVersion = appVersion;
        this.journalFile = new File(directory, JOURNAL_FILE);
        this.journalFileTmp = new File(directory, JOURNAL_FILE_TEMP);
        this.journalFileBackup = new File(directory, JOURNAL_FILE_BACKUP);
        this.valueCount = valueCount;
        this.maxSize = maxSize;
    }

    public static LruDiskCache open(File directory, int appVersion, int valueCount, long maxSize) throws IOException {
        if (maxSize <= 0L) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        if (valueCount <= 0) {
            throw new IllegalArgumentException("valueCount <= 0");
        }
        File backupFile = new File(directory, JOURNAL_FILE_BACKUP);
        if (backupFile.exists()) {
            File journalFile = new File(directory, JOURNAL_FILE);
            if (journalFile.exists()) {
                backupFile.delete();
            } else {
                LruDiskCache.renameTo(backupFile, journalFile, false);
            }
        }
        LruDiskCache cache = new LruDiskCache(directory, appVersion, valueCount, maxSize);
        if (cache.journalFile.exists()) {
            try {
                cache.readJournal();
                cache.processJournal();
                cache.journalWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(cache.journalFile, true), "US-ASCII"));
                return cache;
            }
            catch (Throwable journalIsCorrupt) {
                LogUtils.e("DiskLruCache " + directory + " is corrupt: " + journalIsCorrupt.getMessage() + ", removing", journalIsCorrupt);
                cache.delete();
            }
        }
        directory.mkdirs();
        cache = new LruDiskCache(directory, appVersion, valueCount, maxSize);
        cache.rebuildJournal();
        return cache;
    }

    private void readJournal() throws IOException {
        StrictLineReader reader = null;
        try {
            reader = new StrictLineReader(new FileInputStream(this.journalFile));
            String magic = reader.readLine();
            String version = reader.readLine();
            String appVersionString = reader.readLine();
            String valueCountString = reader.readLine();
            String blank = reader.readLine();
            if (!(MAGIC.equals(magic) && VERSION_1.equals(version) && Integer.toString(this.appVersion).equals(appVersionString) && Integer.toString(this.valueCount).equals(valueCountString) && "".equals(blank))) {
                throw new IOException("unexpected journal header: [" + magic + ", " + version + ", " + valueCountString + ", " + blank + "]");
            }
            int lineCount = 0;
            try {
                while (true) {
                    this.readJournalLine(reader.readLine());
                    ++lineCount;
                }
            }
            catch (EOFException eOFException) {
                this.redundantOpCount = lineCount - this.lruEntries.size();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly(reader);
    }

    private void readJournalLine(String line) throws IOException {
        Entry entry;
        String diskKey;
        int firstSpace = line.indexOf(32);
        if (firstSpace == -1) {
            throw new IOException("unexpected journal line: " + line);
        }
        int keyBegin = firstSpace + 1;
        int secondSpace = line.indexOf(32, keyBegin);
        if (secondSpace == -1) {
            diskKey = line.substring(keyBegin);
            if (firstSpace == REMOVE.length() && line.startsWith(REMOVE)) {
                this.lruEntries.remove(diskKey);
                return;
            }
        } else {
            diskKey = line.substring(keyBegin, secondSpace);
        }
        if ((entry = this.lruEntries.get(diskKey)) == null) {
            entry = new Entry(diskKey);
            this.lruEntries.put(diskKey, entry);
        }
        if (secondSpace != -1 && firstSpace == CLEAN.length() && line.startsWith(CLEAN)) {
            entry.readable = true;
            entry.currentEditor = null;
            String[] parts = line.substring(secondSpace + 1).split(" ");
            if (parts.length > 0) {
                try {
                    if (parts[0].startsWith("t_")) {
                        entry.expiryTimestamp = Long.valueOf(parts[0].substring(2));
                        entry.setLengths(parts, 1);
                    }
                    entry.expiryTimestamp = Long.MAX_VALUE;
                    entry.setLengths(parts, 0);
                }
                catch (Throwable e) {
                    throw new IOException("unexpected journal line: " + line);
                }
            }
        } else if (secondSpace == -1 && firstSpace == DIRTY.length() && line.startsWith(DIRTY)) {
            entry.currentEditor = new Editor(entry);
        } else if (secondSpace != -1 || firstSpace != READ.length() || !line.startsWith(READ)) {
            throw new IOException("unexpected journal line: " + line);
        }
    }

    private void processJournal() throws IOException {
        LruDiskCache.deleteIfExists(this.journalFileTmp);
        Iterator<Entry> i = this.lruEntries.values().iterator();
        while (i.hasNext()) {
            int t;
            Entry entry = i.next();
            if (entry.currentEditor == null) {
                t = 0;
                while (t < this.valueCount) {
                    this.size += entry.lengths[t];
                    ++t;
                }
                continue;
            }
            entry.currentEditor = null;
            t = 0;
            while (t < this.valueCount) {
                LruDiskCache.deleteIfExists(entry.getCleanFile(t));
                LruDiskCache.deleteIfExists(entry.getDirtyFile(t));
                ++t;
            }
            i.remove();
        }
    }

    private synchronized void rebuildJournal() throws IOException {
        if (this.journalWriter != null) {
            IOUtils.closeQuietly(this.journalWriter);
        }
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.journalFileTmp), "US-ASCII"));
            writer.write(MAGIC);
            writer.write("\n");
            writer.write(VERSION_1);
            writer.write("\n");
            writer.write(Integer.toString(this.appVersion));
            writer.write("\n");
            writer.write(Integer.toString(this.valueCount));
            writer.write("\n");
            writer.write("\n");
            for (Entry entry : this.lruEntries.values()) {
                if (entry.currentEditor != null) {
                    writer.write("DIRTY " + entry.diskKey + '\n');
                    continue;
                }
                writer.write("CLEAN " + entry.diskKey + " t_" + entry.expiryTimestamp + entry.getLengths() + '\n');
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(writer);
            throw throwable;
        }
        IOUtils.closeQuietly(writer);
        if (this.journalFile.exists()) {
            LruDiskCache.renameTo(this.journalFile, this.journalFileBackup, true);
        }
        LruDiskCache.renameTo(this.journalFileTmp, this.journalFile, false);
        this.journalFileBackup.delete();
        this.journalWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.journalFile, true), "US-ASCII"));
    }

    private static void deleteIfExists(File file) throws IOException {
        if (file.exists() && !file.delete()) {
            throw new IOException();
        }
    }

    private static void renameTo(File from, File to, boolean deleteDestination) throws IOException {
        if (deleteDestination) {
            LruDiskCache.deleteIfExists(to);
        }
        if (!from.renameTo(to)) {
            throw new IOException();
        }
    }

    public synchronized long getExpiryTimestamp(String key) throws IOException {
        String diskKey = this.diskCacheFileNameGenerator.generate(key);
        this.checkNotClosed();
        this.validateKey(diskKey);
        Entry entry = this.lruEntries.get(diskKey);
        if (entry == null) {
            return 0L;
        }
        return entry.expiryTimestamp;
    }

    public File getCacheFile(String key, int index) {
        String diskKey = this.diskCacheFileNameGenerator.generate(key);
        return new File(this.directory, String.valueOf(diskKey) + "." + index);
    }

    public Snapshot get(String key) throws IOException {
        String diskKey = this.diskCacheFileNameGenerator.generate(key);
        return this.getByDiskKey(diskKey);
    }

    /*
     * Unable to fully structure code
     */
    private synchronized Snapshot getByDiskKey(String diskKey) throws IOException {
        block11: {
            this.checkNotClosed();
            this.validateKey(diskKey);
            entry = this.lruEntries.get(diskKey);
            if (entry == null) {
                return null;
            }
            if (!Entry.access$0(entry)) {
                return null;
            }
            if (Entry.access$9(entry) < System.currentTimeMillis()) {
                i = 0;
                while (i < this.valueCount) {
                    file = entry.getCleanFile(i);
                    if (file.exists() && !file.delete()) {
                        throw new IOException("failed to delete " + file);
                    }
                    this.size -= Entry.access$8(entry)[i];
                    Entry.access$8((Entry)entry)[i] = 0L;
                    ++i;
                }
                ++this.redundantOpCount;
                this.journalWriter.append("REMOVE " + diskKey + '\n');
                this.lruEntries.remove(diskKey);
                if (this.journalRebuildRequired()) {
                    this.executorService.submit(this.cleanupCallable);
                }
                return null;
            }
            ins = new FileInputStream[this.valueCount];
            try {
                i = 0;
                while (i < this.valueCount) {
                    ins[i] = new FileInputStream(entry.getCleanFile(i));
                    ++i;
                }
                break block11;
            }
            catch (FileNotFoundException e) {
                i = 0;
                ** while (i < this.valueCount)
            }
lbl-1000:
            // 1 sources

            {
                if (ins[i] == null) break;
                IOUtils.closeQuietly(ins[i]);
                ++i;
                continue;
            }
lbl42:
            // 2 sources

            return null;
        }
        ++this.redundantOpCount;
        this.journalWriter.append("READ " + diskKey + '\n');
        if (this.journalRebuildRequired()) {
            this.executorService.submit(this.cleanupCallable);
        }
        return new Snapshot(diskKey, Entry.access$10(entry), ins, Entry.access$8(entry));
    }

    public Editor edit(String key) throws IOException {
        String diskKey = this.diskCacheFileNameGenerator.generate(key);
        return this.editByDiskKey(diskKey, -1L);
    }

    private synchronized Editor editByDiskKey(String diskKey, long expectedSequenceNumber) throws IOException {
        this.checkNotClosed();
        this.validateKey(diskKey);
        Entry entry = this.lruEntries.get(diskKey);
        if (expectedSequenceNumber != -1L && (entry == null || entry.sequenceNumber != expectedSequenceNumber)) {
            return null;
        }
        if (entry == null) {
            entry = new Entry(diskKey);
            this.lruEntries.put(diskKey, entry);
        } else if (entry.currentEditor != null) {
            return null;
        }
        Editor editor = new Editor(entry);
        entry.currentEditor = editor;
        this.journalWriter.write("DIRTY " + diskKey + '\n');
        this.journalWriter.flush();
        return editor;
    }

    public File getDirectory() {
        return this.directory;
    }

    public synchronized long getMaxSize() {
        return this.maxSize;
    }

    public synchronized void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
        this.executorService.submit(this.cleanupCallable);
    }

    public synchronized long size() {
        return this.size;
    }

    private synchronized void completeEdit(Editor editor, boolean success) throws IOException {
        int i;
        Entry entry = editor.entry;
        if (entry.currentEditor != editor) {
            throw new IllegalStateException();
        }
        if (success && !entry.readable) {
            i = 0;
            while (i < this.valueCount) {
                if (!editor.written[i]) {
                    editor.abort();
                    throw new IllegalStateException("Newly created entry didn't create value for index " + i);
                }
                if (!entry.getDirtyFile(i).exists()) {
                    editor.abort();
                    return;
                }
                ++i;
            }
        }
        i = 0;
        while (i < this.valueCount) {
            File dirty = entry.getDirtyFile(i);
            if (success) {
                if (dirty.exists()) {
                    long newLength;
                    File clean = entry.getCleanFile(i);
                    dirty.renameTo(clean);
                    long oldLength = entry.lengths[i];
                    ((Entry)entry).lengths[i] = newLength = clean.length();
                    this.size = this.size - oldLength + newLength;
                }
            } else {
                LruDiskCache.deleteIfExists(dirty);
            }
            ++i;
        }
        ++this.redundantOpCount;
        entry.currentEditor = null;
        if (entry.readable | success) {
            entry.readable = true;
            this.journalWriter.write("CLEAN " + entry.diskKey + " t_" + entry.expiryTimestamp + entry.getLengths() + '\n');
            if (success) {
                entry.sequenceNumber = this.nextSequenceNumber++;
            }
        } else {
            this.lruEntries.remove(entry.diskKey);
            this.journalWriter.write("REMOVE " + entry.diskKey + '\n');
        }
        this.journalWriter.flush();
        if (this.size > this.maxSize || this.journalRebuildRequired()) {
            this.executorService.submit(this.cleanupCallable);
        }
    }

    private boolean journalRebuildRequired() {
        int redundantOpCompactThreshold = 2000;
        return this.redundantOpCount >= 2000 && this.redundantOpCount >= this.lruEntries.size();
    }

    public boolean remove(String key) throws IOException {
        String diskKey = this.diskCacheFileNameGenerator.generate(key);
        return this.removeByDiskKey(diskKey);
    }

    private synchronized boolean removeByDiskKey(String diskKey) throws IOException {
        this.checkNotClosed();
        this.validateKey(diskKey);
        Entry entry = this.lruEntries.get(diskKey);
        if (entry == null || entry.currentEditor != null) {
            return false;
        }
        int i = 0;
        while (i < this.valueCount) {
            File file = entry.getCleanFile(i);
            if (file.exists() && !file.delete()) {
                throw new IOException("failed to delete " + file);
            }
            this.size -= entry.lengths[i];
            ((Entry)entry).lengths[i] = 0L;
            ++i;
        }
        ++this.redundantOpCount;
        this.journalWriter.append("REMOVE " + diskKey + '\n');
        this.lruEntries.remove(diskKey);
        if (this.journalRebuildRequired()) {
            this.executorService.submit(this.cleanupCallable);
        }
        return true;
    }

    public synchronized boolean isClosed() {
        return this.journalWriter == null;
    }

    private void checkNotClosed() {
        if (this.journalWriter == null) {
            throw new IllegalStateException("cache is closed");
        }
    }

    public synchronized void flush() throws IOException {
        this.checkNotClosed();
        this.trimToSize();
        this.journalWriter.flush();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.journalWriter == null) {
            return;
        }
        for (Entry entry : new ArrayList<Entry>(this.lruEntries.values())) {
            if (entry.currentEditor == null) continue;
            entry.currentEditor.abort();
        }
        this.trimToSize();
        this.journalWriter.close();
        this.journalWriter = null;
    }

    private void trimToSize() throws IOException {
        while (this.size > this.maxSize) {
            Map.Entry<String, Entry> toEvict = this.lruEntries.entrySet().iterator().next();
            this.removeByDiskKey(toEvict.getKey());
        }
    }

    public void delete() throws IOException {
        IOUtils.closeQuietly(this);
        LruDiskCache.deleteContents(this.directory);
    }

    private void validateKey(String diskKey) {
        Matcher matcher = LEGAL_KEY_PATTERN.matcher(diskKey);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("keys must match regex [a-z0-9_-]{1,64}: \"" + diskKey + "\"");
        }
    }

    private static String inputStreamToString(InputStream in) throws IOException {
        return LruDiskCache.readFully(new InputStreamReader(in, "UTF-8"));
    }

    private static String readFully(Reader reader) throws IOException {
        StringWriter writer = null;
        try {
            int count;
            writer = new StringWriter();
            char[] buffer = new char[1024];
            while ((count = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, count);
            }
            String string = writer.toString();
            return string;
        }
        finally {
            IOUtils.closeQuietly(reader);
            IOUtils.closeQuietly(writer);
        }
    }

    private static void deleteContents(File dir) throws IOException {
        File[] files = dir.listFiles();
        if (files == null) {
            throw new IOException("not a readable directory: " + dir);
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                LruDiskCache.deleteContents(file);
            }
            if (file.exists() && !file.delete()) {
                throw new IOException("failed to delete file: " + file);
            }
            ++n2;
        }
    }

    public DiskCacheFileNameGenerator getDiskCacheFileNameGenerator() {
        return this.diskCacheFileNameGenerator;
    }

    public void setDiskCacheFileNameGenerator(DiskCacheFileNameGenerator diskCacheFileNameGenerator) {
        if (diskCacheFileNameGenerator != null) {
            this.diskCacheFileNameGenerator = diskCacheFileNameGenerator;
        }
    }

    public static interface DiskCacheFileNameGenerator {
        public String generate(String var1);
    }

    public final class Editor {
        private final Entry entry;
        private final boolean[] written;
        private boolean hasErrors;
        private boolean committed;

        private Editor(Entry entry) {
            this.entry = entry;
            this.written = entry.readable ? null : new boolean[LruDiskCache.this.valueCount];
        }

        public void setEntryExpiryTimestamp(long timestamp) {
            this.entry.expiryTimestamp = timestamp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputStream newInputStream(int index) throws IOException {
            LruDiskCache lruDiskCache = LruDiskCache.this;
            synchronized (lruDiskCache) {
                block7: {
                    if (this.entry.currentEditor != this) {
                        throw new IllegalStateException();
                    }
                    if (this.entry.readable) break block7;
                    return null;
                }
                try {
                    return new FileInputStream(this.entry.getCleanFile(index));
                }
                catch (FileNotFoundException e) {
                    return null;
                }
            }
        }

        public String getString(int index) throws IOException {
            InputStream in = this.newInputStream(index);
            return in != null ? LruDiskCache.inputStreamToString(in) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public OutputStream newOutputStream(int index) throws IOException {
            LruDiskCache lruDiskCache = LruDiskCache.this;
            synchronized (lruDiskCache) {
                FileOutputStream outputStream;
                if (this.entry.currentEditor != this) {
                    throw new IllegalStateException();
                }
                if (!this.entry.readable) {
                    this.written[index] = true;
                }
                File dirtyFile = this.entry.getDirtyFile(index);
                try {
                    outputStream = new FileOutputStream(dirtyFile);
                }
                catch (FileNotFoundException e) {
                    LruDiskCache.this.directory.mkdirs();
                    try {
                        outputStream = new FileOutputStream(dirtyFile);
                    }
                    catch (FileNotFoundException e2) {
                        return NULL_OUTPUT_STREAM;
                    }
                }
                return new FaultHidingOutputStream(outputStream);
            }
        }

        public void set(int index, String value) throws IOException {
            OutputStreamWriter writer = null;
            try {
                writer = new OutputStreamWriter(this.newOutputStream(index), "UTF-8");
                writer.write(value);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly(writer);
        }

        public void commit() throws IOException {
            if (this.hasErrors) {
                LruDiskCache.this.completeEdit(this, false);
                LruDiskCache.this.removeByDiskKey(this.entry.diskKey);
            } else {
                LruDiskCache.this.completeEdit(this, true);
            }
            this.committed = true;
        }

        public void abort() throws IOException {
            LruDiskCache.this.completeEdit(this, false);
        }

        public void abortUnlessCommitted() {
            if (!this.committed) {
                try {
                    this.abort();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        private class FaultHidingOutputStream
        extends FilterOutputStream {
            private FaultHidingOutputStream(OutputStream out) {
                super(out);
            }

            @Override
            public void write(int oneByte) {
                try {
                    this.out.write(oneByte);
                }
                catch (Throwable e) {
                    Editor.this.hasErrors = true;
                }
            }

            @Override
            public void write(byte[] buffer, int offset, int length) {
                try {
                    this.out.write(buffer, offset, length);
                    this.out.flush();
                }
                catch (Throwable e) {
                    Editor.this.hasErrors = true;
                }
            }

            @Override
            public void close() {
                try {
                    this.out.close();
                }
                catch (Throwable e) {
                    Editor.this.hasErrors = true;
                }
            }

            @Override
            public void flush() {
                try {
                    this.out.flush();
                }
                catch (Throwable e) {
                    Editor.this.hasErrors = true;
                }
            }
        }
    }

    private final class Entry {
        private final String diskKey;
        private long expiryTimestamp = Long.MAX_VALUE;
        private final long[] lengths;
        private boolean readable;
        private Editor currentEditor;
        private long sequenceNumber;

        private Entry(String diskKey) {
            this.diskKey = diskKey;
            this.lengths = new long[LruDiskCache.this.valueCount];
        }

        public String getLengths() throws IOException {
            StringBuilder result = new StringBuilder();
            long[] lArray = this.lengths;
            int n = this.lengths.length;
            int n2 = 0;
            while (n2 < n) {
                long size = lArray[n2];
                result.append(' ').append(size);
                ++n2;
            }
            return result.toString();
        }

        private void setLengths(String[] strings, int startIndex) throws IOException {
            if (strings.length - startIndex != LruDiskCache.this.valueCount) {
                throw this.invalidLengths(strings);
            }
            try {
                int i = 0;
                while (i < LruDiskCache.this.valueCount) {
                    this.lengths[i] = Long.parseLong(strings[i + startIndex]);
                    ++i;
                }
            }
            catch (NumberFormatException e) {
                throw this.invalidLengths(strings);
            }
        }

        private IOException invalidLengths(String[] strings) throws IOException {
            throw new IOException("unexpected journal line: " + Arrays.toString(strings));
        }

        public File getCleanFile(int i) {
            return new File(LruDiskCache.this.directory, String.valueOf(this.diskKey) + "." + i);
        }

        public File getDirtyFile(int i) {
            return new File(LruDiskCache.this.directory, String.valueOf(this.diskKey) + "." + i + ".tmp");
        }
    }

    public class MD5DiskCacheFileNameGenerator
    implements DiskCacheFileNameGenerator {
        @Override
        public String generate(String key) {
            String cacheKey;
            try {
                MessageDigest mDigest = MessageDigest.getInstance("MD5");
                mDigest.update(key.getBytes());
                cacheKey = this.bytesToHexString(mDigest.digest());
            }
            catch (NoSuchAlgorithmException e) {
                cacheKey = String.valueOf(key.hashCode());
            }
            return cacheKey;
        }

        private String bytesToHexString(byte[] bytes) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < bytes.length) {
                String hex = Integer.toHexString(0xFF & bytes[i]);
                if (hex.length() == 1) {
                    sb.append('0');
                }
                sb.append(hex);
                ++i;
            }
            return sb.toString();
        }
    }

    public final class Snapshot
    implements Closeable {
        private final String diskKey;
        private final long sequenceNumber;
        private final FileInputStream[] ins;
        private final long[] lengths;

        private Snapshot(String diskKey, long sequenceNumber, FileInputStream[] ins, long[] lengths) {
            this.diskKey = diskKey;
            this.sequenceNumber = sequenceNumber;
            this.ins = ins;
            this.lengths = lengths;
        }

        public Editor edit() throws IOException {
            return LruDiskCache.this.editByDiskKey(this.diskKey, this.sequenceNumber);
        }

        public FileInputStream getInputStream(int index) {
            return this.ins[index];
        }

        public String getString(int index) throws IOException {
            return LruDiskCache.inputStreamToString(this.getInputStream(index));
        }

        public long getLength(int index) {
            return this.lengths[index];
        }

        @Override
        public void close() {
            FileInputStream[] fileInputStreamArray = this.ins;
            int n = this.ins.length;
            int n2 = 0;
            while (n2 < n) {
                FileInputStream in = fileInputStreamArray[n2];
                IOUtils.closeQuietly(in);
                ++n2;
            }
        }
    }

    private class StrictLineReader
    implements Closeable {
        private static final byte CR = 13;
        private static final byte LF = 10;
        private final InputStream in;
        private final Charset charset = Charset.forName("US-ASCII");
        private byte[] buf;
        private int pos;
        private int end;

        public StrictLineReader(InputStream in) {
            this(in, 8192);
        }

        public StrictLineReader(InputStream in, int capacity) {
            if (in == null) {
                throw new NullPointerException();
            }
            if (capacity < 0) {
                throw new IllegalArgumentException("capacity <= 0");
            }
            this.in = in;
            this.buf = new byte[capacity];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            InputStream inputStream = this.in;
            synchronized (inputStream) {
                if (this.buf != null) {
                    this.buf = null;
                    this.in.close();
                }
            }
        }

        public String readLine() throws IOException {
            InputStream inputStream = this.in;
            synchronized (inputStream) {
                if (this.buf == null) {
                    throw new IOException("LineReader is closed");
                }
                if (this.pos >= this.end) {
                    this.fillBuf();
                }
                int i = this.pos;
                while (i != this.end) {
                    if (this.buf[i] == 10) {
                        int lineEnd = i != this.pos && this.buf[i - 1] == 13 ? i - 1 : i;
                        String res = new String(this.buf, this.pos, lineEnd - this.pos, this.charset.name());
                        this.pos = i + 1;
                        return res;
                    }
                    ++i;
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream(this.end - this.pos + 80){

                    @Override
                    public String toString() {
                        int length = this.count > 0 && this.buf[this.count - 1] == 13 ? this.count - 1 : this.count;
                        try {
                            return new String(this.buf, 0, length, StrictLineReader.this.charset.name());
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new AssertionError((Object)e);
                        }
                    }
                };
                block4: while (true) {
                    out.write(this.buf, this.pos, this.end - this.pos);
                    this.end = -1;
                    this.fillBuf();
                    int i2 = this.pos;
                    while (true) {
                        if (i2 == this.end) continue block4;
                        if (this.buf[i2] == 10) {
                            if (i2 != this.pos) {
                                out.write(this.buf, this.pos, i2 - this.pos);
                            }
                            out.flush();
                            this.pos = i2 + 1;
                            return out.toString();
                        }
                        ++i2;
                    }
                    break;
                }
            }
        }

        private void fillBuf() throws IOException {
            int result = this.in.read(this.buf, 0, this.buf.length);
            if (result == -1) {
                throw new EOFException();
            }
            this.pos = 0;
            this.end = result;
        }
    }
}

