package module_android_demo.example.com.demo_printer.fragment;

import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.Fragment;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.Toast;


import java.lang.reflect.Field;

import module_android_demo.example.com.demo_printer.MainActivity;
import module_android_demo.example.com.demo_printer.R;

public class PrinterSetFragment extends Fragment implements View.OnClickListener{
    Spinner spSpeed, spGray, spCodepage;
    MainActivity mContext;
    Button btPrintSet, btnPrintCodepage;
    CheckBox cbItalic,  cbFrame, cbBold, cbdoubleWidth, cbDoubleHigh, cbUnderline ,cbWhite;
    EditText LeftMargin,RightMargin,edtRowSpacing;

    private final int[] array_codepage = new int[]{0,1,2,3,4,5,6,7,8,11,12,13,14,15,16,17,18,19,20,21,
    22,23,24,25,26,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,66,67,68,69,
    70,71,72,73,74,75,82};

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_printer_set, container, false);
    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        mContext = (MainActivity) getActivity();
        spSpeed=(Spinner) mContext.findViewById(R.id.spSpeed);
        spGray=(Spinner)mContext.findViewById(R.id.spGray);
        spCodepage=(Spinner)mContext.findViewById(R.id.spCodepage);

        LeftMargin=(EditText) mContext.findViewById(R.id.LeftMargin);
        RightMargin=(EditText)mContext.findViewById(R.id.RightMargin);
        edtRowSpacing=(EditText)mContext.findViewById(R.id.edtRowSpacing);

        cbItalic=(CheckBox)mContext.findViewById(R.id.cbItalic);
        cbFrame=(CheckBox)mContext.findViewById(R.id.cbFrame);
        cbBold=(CheckBox)mContext.findViewById(R.id.cbBold);
        cbdoubleWidth=(CheckBox)mContext.findViewById(R.id.cbdoubleWidth);
        cbDoubleHigh=(CheckBox)mContext.findViewById(R.id.cbDoubleHigh);
        cbUnderline=(CheckBox)mContext.findViewById(R.id.cbUnderline);
        cbWhite=(CheckBox)mContext.findViewById(R.id.cbWhite);

        btPrintSet=(Button) mContext.findViewById(R.id.btPrintSet);
        btnPrintCodepage=(Button) mContext.findViewById(R.id.btnPrintCodepage);
        btPrintSet.setOnClickListener(this);
        btnPrintCodepage.setOnClickListener(this);
    }

    @Override
    public void onResume() {
        super.onResume();
        init();
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();

        //restore codepage
        mContext.mPrinter.setPrintCodePage(mContext.codepage);
    }

    @Override
    public void onClick(View v) {
        switch (v.getId()){
            case  R.id.btPrintSet:
                if (!mContext.isPrinterOpened) {
                    Toast.makeText(mContext, "Open printer first", Toast.LENGTH_SHORT).show();
                    return;
                }
                setRowSpacing();
                setMargin();
                setGray();
                setSpeed();
                setCharacterStyle();
                setCodePage();
                Toast.makeText(mContext,"complete",Toast.LENGTH_SHORT).show();
                break;

            case R.id.btnPrintCodepage:
                if (!mContext.isPrinterOpened) {
                    Toast.makeText(mContext, "Open printer first", Toast.LENGTH_SHORT).show();
                    return;
                }
                //print codepage characters
                int index = spCodepage.getSelectedItemPosition();
                Log.i("PrinterSetFragment", "print codepage " + array_codepage[index]);
                mContext.mPrinter.setPrintCodePage(array_codepage[index]);

                byte[] data = new byte[16*14];
                for (int i=0; i<(16*14); i++) {
                    data[i] = (byte)(0x20 + i);
                }
                mContext.mPrinter.print(data);
                mContext.printFeed();
                break;
        }
    }

    //设置灰度
    private void setGray(){
        int gray=spGray.getSelectedItemPosition()+1;
        mContext.gray=spGray.getSelectedItemPosition();
        mContext.mPrinter.setPrintGrayLevel(gray);
    }

    //设置速度
    private void setSpeed(){
        int speed=spSpeed.getSelectedItemPosition();
        mContext.speed=spSpeed.getSelectedItemPosition();
        mContext.mPrinter.setPrintSpeed(speed);
    }

    //设置字体
    private void setCharacterStyle(){
        boolean italic=cbItalic.isChecked();
        boolean frame=cbFrame.isChecked();
        boolean bold=cbBold.isChecked();
        boolean doubleWidth=cbdoubleWidth.isChecked();
        boolean doubleHigh=cbDoubleHigh.isChecked();
        boolean white=cbWhite.isChecked();
        boolean underline=cbUnderline.isChecked();
        mContext.isItalic=italic;
        mContext.isFrame=frame;
        mContext.isBold=bold;
        mContext.isdoubleWidth=doubleWidth;
        mContext.isDoubleHigh=doubleHigh;
        mContext.isWhite=white;
        mContext.isUnderline=underline;
        mContext.mPrinter.setPrintCharacterStyle(italic,frame,bold,doubleWidth,doubleHigh,white,underline);
    }

    //设置行间距
    private void setRowSpacing(){
         String sapcing=edtRowSpacing.getText().toString();
         if(sapcing==null || sapcing.isEmpty()){
             Toast.makeText(mContext,getResources().getString(R.string.printRowSpacingFail),Toast.LENGTH_SHORT).show();
             return;
         }
        int s=Integer.parseInt(sapcing);
        if(s>255 || s<0){
            Toast.makeText(mContext,getResources().getString(R.string.printRowSpacingFail),Toast.LENGTH_SHORT).show();
            return;
        }
        mContext.rowSpacing=s;
        mContext.mPrinter.setPrintRowSpacing(s);
    }

   //设置左右边距
    private void setMargin(){
        String left=  LeftMargin.getText().toString();
        String right= RightMargin.getText().toString();
        if(left==null || left.isEmpty()){
            Toast.makeText(mContext,getResources().getString(R.string.printLeftRightMargin),Toast.LENGTH_SHORT).show();
            return;
        }
        if(right==null || right.isEmpty()){
            Toast.makeText(mContext,getResources().getString(R.string.printLeftRightMargin),Toast.LENGTH_SHORT).show();
            return;
        }

        int l=Integer.parseInt(left);
        int r=Integer.parseInt(right);

        if(l>47 || l<0 || r>47 || r<0){
            Toast.makeText(mContext,getResources().getString(R.string.printLeftRightMargin),Toast.LENGTH_SHORT).show();
            return;
        }

        if((l+r)>47){
            Toast.makeText(mContext,getResources().getString(R.string.printLeftRightMargin),Toast.LENGTH_SHORT).show();
            return;
        }

        mContext.leftMargin=l;
        mContext.rightMargin=r;

        mContext.mPrinter.setPrintLeftMargin(l);
        mContext.mPrinter.setPrintRightMargin(r);
    }

    //设置代码页
    private void setCodePage(){
        int index = spCodepage.getSelectedItemPosition();
        Log.i("PrinterSetFragment", "set codepage " + array_codepage[index]);
        mContext.mPrinter.setPrintCodePage(array_codepage[index]);
        mContext.codepage = array_codepage[index];
    }

    //初始化参数
    private void init(){
        cbItalic.setChecked(mContext.isItalic);
        cbFrame.setChecked(mContext.isFrame);
        cbBold.setChecked(mContext.isBold);
        cbdoubleWidth.setChecked(mContext.isdoubleWidth);
        cbDoubleHigh.setChecked(mContext.isDoubleHigh);
        cbUnderline.setChecked(mContext.isUnderline);
        cbWhite.setChecked(mContext.isWhite);

        spGray.setSelection(mContext.gray);
        spSpeed.setSelection(mContext.speed);
        for(int i=0; i<array_codepage.length; i++) {
            if (mContext.codepage == array_codepage[i]) {
                spCodepage.setSelection(i);
                break;
            }
        }

        edtRowSpacing.setText(mContext.rowSpacing+"");
        LeftMargin.setText(mContext.leftMargin+"");
        RightMargin.setText(mContext.rightMargin+"");
    }

}
