/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xml.stream;

import aavax.xml.namespace.NamespaceContext;
import aavax.xml.namespace.QName;
import aavax.xml.stream.Location;
import aavax.xml.stream.XMLEventFactory;
import aavax.xml.stream.events.Attribute;
import aavax.xml.stream.events.Characters;
import aavax.xml.stream.events.Comment;
import aavax.xml.stream.events.DTD;
import aavax.xml.stream.events.EndDocument;
import aavax.xml.stream.events.EndElement;
import aavax.xml.stream.events.EntityDeclaration;
import aavax.xml.stream.events.EntityReference;
import aavax.xml.stream.events.Namespace;
import aavax.xml.stream.events.ProcessingInstruction;
import aavax.xml.stream.events.StartDocument;
import aavax.xml.stream.events.StartElement;
import com.bea.xml.stream.AttributeBase;
import com.bea.xml.stream.NamespaceBase;
import com.bea.xml.stream.events.CharactersEvent;
import com.bea.xml.stream.events.CommentEvent;
import com.bea.xml.stream.events.DTDEvent;
import com.bea.xml.stream.events.EndDocumentEvent;
import com.bea.xml.stream.events.EndElementEvent;
import com.bea.xml.stream.events.EntityReferenceEvent;
import com.bea.xml.stream.events.ProcessingInstructionEvent;
import com.bea.xml.stream.events.StartDocumentEvent;
import com.bea.xml.stream.events.StartElementEvent;
import java.util.Iterator;

public class EventFactory
extends XMLEventFactory {
    private Location location;

    public void setLocation(Location l) {
        this.location = l;
    }

    public Attribute createAttribute(QName name, String value) {
        return new AttributeBase(name, value);
    }

    public Attribute createAttribute(String localName, String value) {
        return new AttributeBase("", localName, value);
    }

    public Attribute createAttribute(String prefix, String namespaceURI, String localName, String value) {
        return new AttributeBase(prefix, namespaceURI, localName, value, "CDATA");
    }

    public Namespace createNamespace(String namespaceURI) {
        return new NamespaceBase(namespaceURI);
    }

    public Namespace createNamespace(String prefix, String namespaceUri) {
        if (prefix == null) {
            throw new NullPointerException("The prefix of a namespace may not be set to null");
        }
        return new NamespaceBase(prefix, namespaceUri);
    }

    public StartElement createStartElement(QName name, Iterator attributes, Iterator namespaces) {
        StartElementEvent e = new StartElementEvent(name);
        while (attributes != null && attributes.hasNext()) {
            e.addAttribute((Attribute)attributes.next());
        }
        while (namespaces != null && namespaces.hasNext()) {
            e.addNamespace((Namespace)namespaces.next());
        }
        return e;
    }

    public StartElement createStartElement(String prefix, String namespaceUri, String localName) {
        return new StartElementEvent(new QName(namespaceUri, localName, prefix));
    }

    public static String checkPrefix(String prefix) {
        if (prefix == null) {
            return "";
        }
        return prefix;
    }

    public StartElement createStartElement(String prefix, String namespaceUri, String localName, Iterator attributes, Iterator namespaces) {
        prefix = EventFactory.checkPrefix(prefix);
        StartElementEvent e = new StartElementEvent(new QName(namespaceUri, localName, prefix));
        while (attributes != null && attributes.hasNext()) {
            e.addAttribute((Attribute)attributes.next());
        }
        while (namespaces != null && namespaces.hasNext()) {
            e.addNamespace((Namespace)namespaces.next());
        }
        return e;
    }

    public StartElement createStartElement(String prefix, String namespaceUri, String localName, Iterator attributes, Iterator namespaces, NamespaceContext context) {
        prefix = EventFactory.checkPrefix(prefix);
        StartElementEvent e = new StartElementEvent(new QName(namespaceUri, localName, prefix));
        while (attributes != null && attributes.hasNext()) {
            e.addAttribute((Attribute)attributes.next());
        }
        while (namespaces != null && namespaces.hasNext()) {
            e.addNamespace((Namespace)namespaces.next());
        }
        e.setNamespaceContext(context);
        return e;
    }

    public EndElement createEndElement(QName name, Iterator namespaces) {
        EndElementEvent e = new EndElementEvent(name);
        while (namespaces != null && namespaces.hasNext()) {
            e.addNamespace((Namespace)namespaces.next());
        }
        return e;
    }

    public EndElement createEndElement(String prefix, String namespaceUri, String localName) {
        prefix = EventFactory.checkPrefix(prefix);
        return new EndElementEvent(new QName(namespaceUri, localName, prefix));
    }

    public EndElement createEndElement(String prefix, String namespaceUri, String localName, Iterator namespaces) {
        prefix = EventFactory.checkPrefix(prefix);
        EndElementEvent e = new EndElementEvent(new QName(namespaceUri, localName, prefix));
        while (namespaces.hasNext()) {
            e.addNamespace((Namespace)namespaces.next());
        }
        return e;
    }

    public Characters createCharacters(String content) {
        return new CharactersEvent(content);
    }

    public Characters createCData(String content) {
        return new CharactersEvent(content, true);
    }

    public StartDocument createStartDocument() {
        return new StartDocumentEvent();
    }

    public StartDocument createStartDocument(String encoding, String version, boolean standalone) {
        StartDocumentEvent e = new StartDocumentEvent();
        e.setEncoding(encoding);
        e.setVersion(version);
        e.setStandalone(standalone);
        return e;
    }

    public StartDocument createStartDocument(String encoding, String version) {
        StartDocumentEvent e = new StartDocumentEvent();
        e.setEncoding(encoding);
        e.setVersion(version);
        return e;
    }

    public StartDocument createStartDocument(String encoding) {
        StartDocumentEvent e = new StartDocumentEvent();
        e.setEncoding(encoding);
        return e;
    }

    public EndDocument createEndDocument() {
        return new EndDocumentEvent();
    }

    public EntityReference createEntityReference(String name, EntityDeclaration declaration) {
        return new EntityReferenceEvent(name, declaration);
    }

    public Characters createSpace(String content) {
        CharactersEvent c = new CharactersEvent(content);
        c.setSpace(true);
        return c;
    }

    public Characters createIgnorableSpace(String content) {
        CharactersEvent c = new CharactersEvent(content);
        c.setSpace(true);
        c.setIgnorable(true);
        return c;
    }

    public Comment createComment(String text) {
        return new CommentEvent(text);
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) {
        return new ProcessingInstructionEvent(target, data);
    }

    public DTD createDTD(String dtd) {
        return new DTDEvent(dtd);
    }
}

