/*
 * Decompiled with CFR 0.152.
 */
package com.lidroid.xutils.http.client.multipart.content;

import com.lidroid.xutils.http.client.multipart.content.AbstractContentBody;
import com.lidroid.xutils.util.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;

public class FileBody
extends AbstractContentBody {
    private final File file;
    private final String filename;
    private final String charset;

    public FileBody(File file, String filename, String mimeType, String charset) {
        super(mimeType);
        if (file == null) {
            throw new IllegalArgumentException("File may not be null");
        }
        this.file = file;
        this.filename = filename != null ? filename : file.getName();
        this.charset = charset;
    }

    public FileBody(File file, String mimeType, String charset) {
        this(file, null, mimeType, charset);
    }

    public FileBody(File file, String mimeType) {
        this(file, null, mimeType, null);
    }

    public FileBody(File file) {
        this(file, null, "application/octet-stream", null);
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("Output stream may not be null");
        }
        FileInputStream in = null;
        try {
            int l;
            in = new FileInputStream(this.file);
            byte[] tmp = new byte[4096];
            while ((l = ((InputStream)in).read(tmp)) != -1) {
                out.write(tmp, 0, l);
                this.callBackInfo.pos += (long)l;
                if (this.callBackInfo.doCallBack(false)) continue;
                throw new InterruptedIOException("stop");
            }
            out.flush();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly(in);
    }

    @Override
    public String getTransferEncoding() {
        return "binary";
    }

    @Override
    public String getCharset() {
        return this.charset;
    }

    @Override
    public long getContentLength() {
        return this.file.length();
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    public File getFile() {
        return this.file;
    }
}

