/*
 * Decompiled with CFR 0.152.
 */
package com.lidroid.xutils.http.client.multipart.content;

import com.lidroid.xutils.http.client.multipart.MultipartEntity;
import com.lidroid.xutils.http.client.multipart.content.ContentBody;

public abstract class AbstractContentBody
implements ContentBody {
    private final String mimeType;
    private final String mediaType;
    private final String subType;
    protected MultipartEntity.CallBackInfo callBackInfo = MultipartEntity.CallBackInfo.DEFAULT;

    public AbstractContentBody(String mimeType) {
        if (mimeType == null) {
            throw new IllegalArgumentException("MIME type may not be null");
        }
        this.mimeType = mimeType;
        int i = mimeType.indexOf(47);
        if (i != -1) {
            this.mediaType = mimeType.substring(0, i);
            this.subType = mimeType.substring(i + 1);
        } else {
            this.mediaType = mimeType;
            this.subType = null;
        }
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public String getMediaType() {
        return this.mediaType;
    }

    @Override
    public String getSubType() {
        return this.subType;
    }

    @Override
    public void setCallBackInfo(MultipartEntity.CallBackInfo callBackInfo) {
        this.callBackInfo = callBackInfo;
    }
}

