/*
 * Decompiled with CFR 0.152.
 */
package com.lidroid.xutils.bitmap.core;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
import android.view.View;
import com.lidroid.xutils.BitmapUtils;
import java.lang.ref.WeakReference;

public class AsyncDrawable<T extends View>
extends Drawable {
    private final WeakReference<BitmapUtils.BitmapLoadTask<T>> bitmapLoadTaskReference;
    private final Drawable baseDrawable;

    public AsyncDrawable(Drawable drawable, BitmapUtils.BitmapLoadTask<T> bitmapWorkerTask) {
        if (drawable == null) {
            throw new IllegalArgumentException("drawable may not be null");
        }
        if (bitmapWorkerTask == null) {
            throw new IllegalArgumentException("bitmapWorkerTask may not be null");
        }
        this.baseDrawable = drawable;
        this.bitmapLoadTaskReference = new WeakReference<BitmapUtils.BitmapLoadTask<BitmapUtils.BitmapLoadTask<T>>>(bitmapWorkerTask);
    }

    public BitmapUtils.BitmapLoadTask<T> getBitmapWorkerTask() {
        return (BitmapUtils.BitmapLoadTask)this.bitmapLoadTaskReference.get();
    }

    public void draw(Canvas canvas) {
        this.baseDrawable.draw(canvas);
    }

    public void setAlpha(int i) {
        this.baseDrawable.setAlpha(i);
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.baseDrawable.setColorFilter(colorFilter);
    }

    public int getOpacity() {
        return this.baseDrawable.getOpacity();
    }

    public void setBounds(int left, int top, int right, int bottom) {
        this.baseDrawable.setBounds(left, top, right, bottom);
    }

    public void setBounds(Rect bounds) {
        this.baseDrawable.setBounds(bounds);
    }

    public void setChangingConfigurations(int configs) {
        this.baseDrawable.setChangingConfigurations(configs);
    }

    public int getChangingConfigurations() {
        return this.baseDrawable.getChangingConfigurations();
    }

    public void setDither(boolean dither) {
        this.baseDrawable.setDither(dither);
    }

    public void setFilterBitmap(boolean filter) {
        this.baseDrawable.setFilterBitmap(filter);
    }

    public void invalidateSelf() {
        this.baseDrawable.invalidateSelf();
    }

    public void scheduleSelf(Runnable what, long when) {
        this.baseDrawable.scheduleSelf(what, when);
    }

    public void unscheduleSelf(Runnable what) {
        this.baseDrawable.unscheduleSelf(what);
    }

    public void setColorFilter(int color, PorterDuff.Mode mode) {
        this.baseDrawable.setColorFilter(color, mode);
    }

    public void clearColorFilter() {
        this.baseDrawable.clearColorFilter();
    }

    public boolean isStateful() {
        return this.baseDrawable.isStateful();
    }

    public boolean setState(int[] stateSet) {
        return this.baseDrawable.setState(stateSet);
    }

    public int[] getState() {
        return this.baseDrawable.getState();
    }

    public Drawable getCurrent() {
        return this.baseDrawable.getCurrent();
    }

    public boolean setVisible(boolean visible, boolean restart) {
        return this.baseDrawable.setVisible(visible, restart);
    }

    public Region getTransparentRegion() {
        return this.baseDrawable.getTransparentRegion();
    }

    public int getIntrinsicWidth() {
        return this.baseDrawable.getIntrinsicWidth();
    }

    public int getIntrinsicHeight() {
        return this.baseDrawable.getIntrinsicHeight();
    }

    public int getMinimumWidth() {
        return this.baseDrawable.getMinimumWidth();
    }

    public int getMinimumHeight() {
        return this.baseDrawable.getMinimumHeight();
    }

    public boolean getPadding(Rect padding) {
        return this.baseDrawable.getPadding(padding);
    }

    public Drawable mutate() {
        return this.baseDrawable.mutate();
    }

    public Drawable.ConstantState getConstantState() {
        return this.baseDrawable.getConstantState();
    }
}

