/*
 * Decompiled with CFR 0.152.
 */
package com.lidroid.xutils.db.sqlite;

import com.lidroid.xutils.db.sqlite.Selector;
import com.lidroid.xutils.db.table.ColumnUtils;
import com.lidroid.xutils.db.table.Finder;
import com.lidroid.xutils.db.table.TableUtils;
import com.lidroid.xutils.exception.DbException;
import java.util.List;

public class FinderLazyLoader<T> {
    private final Finder finderColumn;
    private final Object finderValue;

    public FinderLazyLoader(Class<?> entityType, String fieldName, Object value) {
        this.finderColumn = (Finder)TableUtils.getColumnOrId(entityType, fieldName);
        this.finderValue = ColumnUtils.convert2DbColumnValueIfNeeded(value);
    }

    public FinderLazyLoader(Finder finderColumn, Object value) {
        this.finderColumn = finderColumn;
        this.finderValue = ColumnUtils.convert2DbColumnValueIfNeeded(value);
    }

    public List<T> getAllFromDb() throws DbException {
        List entities = null;
        if (this.finderColumn != null && this.finderColumn.db != null) {
            entities = this.finderColumn.db.findAll(Selector.from(this.finderColumn.getTargetEntityType()).where(this.finderColumn.getTargetColumnName(), "=", this.finderValue));
        }
        return entities;
    }

    public T getFirstFromDb() throws DbException {
        T entity = null;
        if (this.finderColumn != null && this.finderColumn.db != null) {
            entity = this.finderColumn.db.findFirst(Selector.from(this.finderColumn.getTargetEntityType()).where(this.finderColumn.getTargetColumnName(), "=", this.finderValue));
        }
        return entity;
    }
}

