/*
 * Decompiled with CFR 0.152.
 */
package com.lidroid.xutils.bitmap.callback;

import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageView;
import com.lidroid.xutils.bitmap.BitmapDisplayConfig;
import com.lidroid.xutils.bitmap.callback.BitmapLoadFrom;
import com.lidroid.xutils.bitmap.callback.BitmapSetter;

public abstract class BitmapLoadCallBack<T extends View> {
    private BitmapSetter<T> bitmapSetter;

    public void onPreLoad(T container, String uri, BitmapDisplayConfig config) {
    }

    public void onLoadStarted(T container, String uri, BitmapDisplayConfig config) {
    }

    public void onLoading(T container, String uri, BitmapDisplayConfig config, long total, long current) {
    }

    public abstract void onLoadCompleted(T var1, String var2, Bitmap var3, BitmapDisplayConfig var4, BitmapLoadFrom var5);

    public abstract void onLoadFailed(T var1, String var2, Drawable var3);

    public void setBitmapSetter(BitmapSetter<T> bitmapSetter) {
        this.bitmapSetter = bitmapSetter;
    }

    public void setBitmap(T container, Bitmap bitmap) {
        if (this.bitmapSetter != null) {
            this.bitmapSetter.setBitmap(container, bitmap);
        } else if (container instanceof ImageView) {
            ((ImageView)container).setImageBitmap(bitmap);
        } else {
            container.setBackgroundDrawable((Drawable)new BitmapDrawable(container.getResources(), bitmap));
        }
    }

    public void setDrawable(T container, Drawable drawable) {
        if (this.bitmapSetter != null) {
            this.bitmapSetter.setDrawable(container, drawable);
        } else if (container instanceof ImageView) {
            ((ImageView)container).setImageDrawable(drawable);
        } else {
            container.setBackgroundDrawable(drawable);
        }
    }

    public Drawable getDrawable(T container) {
        if (this.bitmapSetter != null) {
            return this.bitmapSetter.getDrawable(container);
        }
        if (container instanceof ImageView) {
            return ((ImageView)container).getDrawable();
        }
        return container.getBackground();
    }
}

