/*
 * Decompiled with CFR 0.152.
 */
package com.lidroid.xutils.bitmap;

import android.content.Context;
import android.os.Environment;
import android.os.StatFs;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.lidroid.xutils.bitmap.core.BitmapSize;
import com.lidroid.xutils.util.LogUtils;
import java.io.File;
import java.lang.reflect.Field;

public class BitmapCommonUtils {
    private static BitmapSize screenSize = null;

    public static String getDiskCacheDir(Context context, String dirName) {
        File externalCacheDir;
        String cachePath = null;
        if ("mounted".equals(Environment.getExternalStorageState()) && (externalCacheDir = context.getExternalCacheDir()) != null) {
            cachePath = externalCacheDir.getPath();
        }
        if (cachePath == null) {
            cachePath = context.getCacheDir().getPath();
        }
        return String.valueOf(cachePath) + File.separator + dirName;
    }

    public static long getAvailableSpace(File dir) {
        try {
            StatFs stats = new StatFs(dir.getPath());
            return (long)stats.getBlockSize() * (long)stats.getAvailableBlocks();
        }
        catch (Throwable e) {
            LogUtils.e(e.getMessage(), e);
            return -1L;
        }
    }

    public static BitmapSize getScreenSize(Context context) {
        if (screenSize == null) {
            screenSize = new BitmapSize();
            DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
            screenSize.setWidth(displayMetrics.widthPixels);
            screenSize.setHeight(displayMetrics.heightPixels);
        }
        return screenSize;
    }

    public static BitmapSize optimizeMaxSizeByView(View view, int maxImageWidth, int maxImageHeight) {
        int width = maxImageWidth;
        int height = maxImageHeight;
        if (width > 0 && height > 0) {
            return new BitmapSize(width, height);
        }
        ViewGroup.LayoutParams params = view.getLayoutParams();
        if (params != null) {
            if (params.width > 0) {
                width = params.width;
            } else if (params.width != -2) {
                width = view.getWidth();
            }
            if (params.height > 0) {
                height = params.height;
            } else if (params.height != -2) {
                height = view.getHeight();
            }
        }
        if (width <= 0) {
            width = BitmapCommonUtils.getImageViewFieldValue(view, "mMaxWidth");
        }
        if (height <= 0) {
            height = BitmapCommonUtils.getImageViewFieldValue(view, "mMaxHeight");
        }
        BitmapSize screenSize = BitmapCommonUtils.getScreenSize(view.getContext());
        if (width <= 0) {
            width = screenSize.getWidth();
        }
        if (height <= 0) {
            height = screenSize.getHeight();
        }
        return new BitmapSize(width, height);
    }

    private static int getImageViewFieldValue(Object object, String fieldName) {
        int value = 0;
        if (object instanceof ImageView) {
            try {
                Field field = ImageView.class.getDeclaredField(fieldName);
                field.setAccessible(true);
                int fieldValue = (Integer)field.get(object);
                if (fieldValue > 0 && fieldValue < Integer.MAX_VALUE) {
                    value = fieldValue;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return value;
    }
}

