//
//  ViewController.m
//  SComP_Demo
//
//  Created by Andreas Wallstabe on 14.06.12.
//  Copyright (c) 2012 Panmobil. All rights reserved.
//

#import "ViewController.h"

@interface ViewController ()

@end

@implementation ViewController

@synthesize buttonSendCommand, connectionStatus, textViewReceivedData, textFieldCommand;

- (void)viewDidLoad
{
    myScanndy = [Scanndy alloc];
    myScanndy.delegate = self;
    [myScanndy init];
    [super viewDidLoad];
}

- (void)viewDidUnload
{
    [super viewDidUnload];
    // Release any retained subviews of the main view.
}

//these three calbacks are mandatory for proper communication:
- (void) scanndyConnectedCallback
{
    connectionStatus.text = @"connected!";
    [connectionStatus setBackgroundColor:[UIColor greenColor]];
}

- (void) scanndyDisconnectedCallback
{
    connectionStatus.text = @"no connection";
    [connectionStatus setBackgroundColor:[UIColor redColor]];
}

//request from scanndy has to be handled here... (this is sync, this is handeled while accessory is still witing for an answer to its request)
- (NSData*) scanndyRequestSyncCallback:(NSData*)request
{
    accessoryRequest = [[NSString alloc] initWithData:request encoding:NSASCIIStringEncoding];
    
    [self addToTextView:accessoryRequest];
    
    //send the answer according to the request
    NSData* response = [@"ok" dataUsingEncoding:NSUTF8StringEncoding];
    return response;
}


//request from scanndy has to be handled here... (this is async, this is handeled while accessory already received an answer to its request)
- (void) scanndyRequestAsyncCallback
{
    //scan barcode, if trigger key was sent from accessory
    if ([accessoryRequest isEqualToString:@"keydata:T"])
    {
        [self scanBarcode];
    }
    return;
}

//simple send function
- (NSData*) sendData:(NSData*)dataToSend withTimout:(NSInteger)timeout
{
    //this is the only necessary method you should call on the class scanndy
    return [myScanndy sendData:dataToSend withTimout:timeout];
}

- (NSString*) sendString:(NSString*)stringToSend withTimeout:(NSInteger)timeout
{
    //convert string to data object
    NSData* dataToSend=[stringToSend dataUsingEncoding:NSUTF8StringEncoding];
    //send data
    NSData* response = [self sendData:dataToSend withTimout:timeout];
    //convert data back to string
    return [[NSString alloc] initWithData:response encoding:NSASCIIStringEncoding];
}

- (NSString*) sendString:(NSString*)stringToSend
{
    return [self sendString:stringToSend withTimeout:1000];
}

- (IBAction) sendTestCommand
{
    [textFieldCommand resignFirstResponder];
    NSString* response = [self sendString:textFieldCommand.text];
    [self addToTextView:response];
}

- (IBAction) scanBarcode
{
    NSString* response = [self sendString:@"barscan:2500" withTimeout:2500];
    [self addToTextView:response];
}

- (IBAction) printOnScreen
{
    NSString* response = [self sendString:@"print:Hello World!" withTimeout:0];
    [self addToTextView:response];
}

- (IBAction) clearScreen
{
    NSString* response = [self sendString:@"clrscr:client" withTimeout:0];
    [self addToTextView:response];
}

- (void) addToTextView:(NSString*)received
{
    //format and output response:
    NSString* resultString = @"";
    
    NSDate* date = [NSDate date];
    
    NSDateFormatter *dateFormatter = [[[NSDateFormatter alloc] init] autorelease];
    [dateFormatter setDateStyle:NSDateFormatterShortStyle];
    [dateFormatter setTimeStyle:NSDateFormatterMediumStyle];
    NSString* dateString = [dateFormatter stringFromDate:date];
    
    resultString = [resultString stringByAppendingString:dateString];
    resultString = [resultString stringByAppendingString:@": "];
    resultString = [resultString stringByAppendingString:received];
    resultString = [resultString stringByAppendingString:@"\n"];
    
    [textViewReceivedData setText:[textViewReceivedData.text stringByAppendingString:resultString]];
    
    NSRange range = NSMakeRange(textViewReceivedData.text.length - 1, 0);
    [textViewReceivedData scrollRangeToVisible:range];
}


- (IBAction) sendTone_c
{
    [self sendString:@"beep:523,250"];
}
- (IBAction) sendTone_d
{
    [self sendString:@"beep:587,250"];
}
- (IBAction) sendTone_e
{
    [self sendString:@"beep:659,250"];
}
- (IBAction) sendTone_f
{
    [self sendString:@"beep:699,250"];
}
- (IBAction) sendTone_g
{
    [self sendString:@"beep:784,250"];
}
- (IBAction) sendTone_a
{
    [self sendString:@"beep:880,250"];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}

@end
