package de.panmobil.scompdemo;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;

import android.content.Context;
import android.util.Log;

public class ScompSplitter {

	// bardata kommt -> ok an scanndy
	// send command an scanndy -> ok kommt von scanndy
	private String tag = "ScompDemo";	// for logging
	private String scompMsg;
	
	private String rawMsgId, rawFlag, rawLen, rawPayload;
	
	public ScompSplitter(Context ctx, String scompMsg) {
		// can use what you want, eg: ... = ctx.getPackageName() or ... = MainActivity.TAG
		this.tag = ctx.getString(R.string.app_name);
		// original scomp msg like scanned
		this.scompMsg = scompMsg;
		initRawVar();
	}
	
	private void initRawVar() {
		try {
			// [a-fA-F0-9]{,4}[RQrq]?[a-fA-F0-9]{,4}[#]?[.]*[a-fA-F0-9]{,8}
			int flagIndex = -1;
			int rauteIndex = -1;
			String regex = "[rqRQ]+";
			Matcher matcher = Pattern.compile(regex).matcher(scompMsg);
			while (matcher.find()) {
				flagIndex = matcher.start();
				break;
			}
			
			if (flagIndex == -1) flagIndex = scompMsg.indexOf('r');
			if (flagIndex == -1) flagIndex = scompMsg.indexOf('R');
			if (flagIndex == -1) flagIndex = scompMsg.indexOf('q');
			if (flagIndex == -1) flagIndex = scompMsg.indexOf('Q');
			if (flagIndex == -1)
				return;
			
			regex = "[#]+";
			matcher = Pattern.compile(regex).matcher(this.scompMsg);
			while (matcher.find()) {
				rauteIndex = matcher.start();
				break;
			}
			if (rauteIndex == -1) rauteIndex = scompMsg.indexOf('#');
			if (rauteIndex == -1)
				return;
			
			rawFlag = "" + scompMsg.charAt(flagIndex);
			rawMsgId = scompMsg.substring(flagIndex-4, flagIndex);
			rawLen = scompMsg.substring(flagIndex+1, rauteIndex);
			rawPayload = scompMsg.substring(rauteIndex+1, scompMsg.length() - 8);
		} catch (Exception e) {
			Log.e(tag, "Can't split the scomp msg in original form", e);
		}
	}

	/*
	 * SComP: 	ssssTnnnnRp....pCCCCCCCC
	 * 
	 * s:		four hex digits message ID, used to match related request/response
	 * T: 		type of packet flag: 'Q' = request, 'R' = response
	 * n: 		length n of payload data
	 * R: 		one octet reserved for future use, set to '#' for the time
	 * p...p:	n octets arbitrary payload data, see below
	 * C:  		8 hex digits CRC-32, covering everything up to
	 */
	
	/*
	 * returns the first four digits / msg id in decimal 
	 * 
	 */
	public int getMsgId() {
		try {
			String msgIdHex = Converter.hex2str(rawMsgId);
			if (msgIdHex == null)
				return -1;

			int mid = Integer.parseInt(msgIdHex, 16);
			MainActivity.lastMsgId = mid;
			return mid;
		} catch (Exception e) {
		}
		
		return -1;
	}
	
	/*
	 * get the flag character 'Q' for request and 'R' for response
	 * if flag isn't 'Q' or 'R' it will return 0
	 */
	public String getFlag() {
		return rawFlag;
	}
	
	/*
	 * get the length of the payload from the scomp-msg
	 * if scomp msg isn't complete or has a error, it returns -1 for error
	 */
	public int getLength() {
		try {
			String hs = Converter.hex2str(rawLen);
			if (hs != null)
				return Integer.valueOf(hs);
		} catch (Exception e) {
		}
		return -1;
	}
	
	/*
	 * get the complete payload, the msg between reserved octet and crc code
	 */
	public String getPayloadData() {
		return (getLength() != -1) ? rawPayload : null;
	}
	
	/* 
	 * read the last 8 digits of a scomp-msg and 
	 * return true if crc in message is the same as crc of payload, 
	 * otherwise return false
	 */
	public boolean isCRC32Ok() {
		try {
			// create a crc from the scans
			String rawtext = rawMsgId + rawFlag + rawLen + "#" + rawPayload;
			CRC32 crc = new CRC32();
			crc.update(rawtext.getBytes());
			long data = crc.getValue();
			
			// check the crc of given crc
			long msgcrc = Converter.hextoLong(this.scompMsg.substring(this.scompMsg.length()-8));
			if (data == msgcrc)
				return true;

		} catch (Exception e) {	}
		return false;
	}
	
	// returns all elements of a scomp-scan in a HashMap
	public Map<String, Object> getAll() {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("msgid", getMsgId());
		map.put("flag", getFlag());
		map.put("length", getLength());
		map.put("payload", getPayloadData());
		map.put("crc", scompMsg.substring(scompMsg.length()-8));
		return map;
	}
	
	public String getRawMsgId() {
		return rawMsgId;
	}

	public String getRawFlag() {
		return rawFlag;
	}

	public String getRawLen() {
		return rawLen;
	}

	public String getRawPayload() {
		return rawPayload;
	}
}
