package de.panmobil.scompdemo;

import java.lang.ref.WeakReference;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

import de.panmobil.scompdemo.BluetoothScanndyService;

import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.Window;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;

public class MainActivity extends Activity implements OnClickListener {

	private TextView ausgabe, titleStatus;
	private EditText eingabe;
	private ScrollView scrollFenster;
	private LinearLayout titleBackground;
	private String standardBeep = "beep:2500,100";
	public static int lastMsgId;
	private int zaehler = 0;
	private BluetoothScanndyService mBluetoothScanndyService;

    private static final int REQUEST_DEVICE = 1;
	
	@Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        requestWindowFeature(Window.FEATURE_CUSTOM_TITLE);
        setContentView(R.layout.scom_demo_main);
        getWindow().setFeatureInt(Window.FEATURE_CUSTOM_TITLE, R.layout.titleleiste);
        
		scrollFenster = (ScrollView) findViewById(R.id.scrollView1);
		
		ausgabe = (TextView) findViewById(R.id.tvAusgabe);
		ausgabe.setText("");

		titleBackground = (LinearLayout) findViewById(R.id.titleMainLayout);
		
		titleStatus = (TextView) findViewById(R.id.titleText);

		eingabe = (EditText) findViewById(R.id.et_commands);
		eingabe.setText( standardBeep );

		((Button)findViewById(R.id.btn_sendCommand)).setOnClickListener(this);
		((Button)findViewById(R.id.btn_scanBarcode)).setOnClickListener(this);
		((Button)findViewById(R.id.btn_printScreen)).setOnClickListener(this);
		((Button)findViewById(R.id.btn_clearScreen)).setOnClickListener(this);
		((Button)findViewById(R.id.btn_c)).setOnClickListener(this);
		((Button)findViewById(R.id.btn_d)).setOnClickListener(this);
		((Button)findViewById(R.id.btn_e)).setOnClickListener(this);
		((Button)findViewById(R.id.btn_f)).setOnClickListener(this);
		((Button)findViewById(R.id.btn_g)).setOnClickListener(this);
		((Button)findViewById(R.id.btn_a)).setOnClickListener(this);
		((Button)findViewById(R.id.button_Connect)).setOnClickListener(this);
		
		lastMsgId = 0;

		mBluetoothScanndyService = new BluetoothScanndyService(this, new BluetoothHandler(this));
	}

	@Override
    public void onDestroy() {
    	mBluetoothScanndyService.stop();
    	
    	super.onDestroy();
    }

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		getMenuInflater().inflate(R.menu.activity_main, menu);
		return true;
	}
	
	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		switch (item.getItemId()) {
			case R.id.menu_settings:
				startBluetooth();
				return true;
		}
		
		return super.onOptionsItemSelected(item);
	}
	
	@Override
	public void onActivityResult(int requestCode, int resultCode, Intent data) {
    	if (requestCode == REQUEST_DEVICE && resultCode == Activity.RESULT_OK) {
    		BluetoothDevice scanndy = BluetoothAdapter.getDefaultAdapter().getRemoteDevice(data.getExtras().getString(DeviceListActivity.EXTRA_DEVICE_ADDRESS));
    		mBluetoothScanndyService.connect(scanndy);
    	}
    }

	@Override
	public void onClick(View v) {
		// on button press use the next message ID to communicate with scanndy
		String lmid = String.valueOf(++lastMsgId);
		
		String txtAusgabe = "";
		switch (v.getId()) {
			case R.id.btn_sendCommand:
				txtAusgabe = ScompResponseBuilder.buildBasicMsg(lmid, eingabe.getText().toString());
				break;
			case R.id.btn_scanBarcode:
				txtAusgabe = ScompResponseBuilder.buildBarscan(lmid, 2500);
				break;
			case R.id.btn_printScreen:
				txtAusgabe = ScompResponseBuilder.buildPrintOnScreen(lmid, "Hello World!");
				break;
			case R.id.btn_clearScreen:
				txtAusgabe = ScompResponseBuilder.buildClearScreen(lmid);
				break;
			case R.id.btn_c:
				txtAusgabe = ScompResponseBuilder.buildBasicMsg(lmid, "beep:523,250");
				break;
			case R.id.btn_d:
				txtAusgabe = ScompResponseBuilder.buildBasicMsg(lmid, "beep:587,250");
				break;
			case R.id.btn_e:
				txtAusgabe = ScompResponseBuilder.buildBasicMsg(lmid, "beep:659,250");
				break;
			case R.id.btn_f:
				txtAusgabe = ScompResponseBuilder.buildBasicMsg(lmid, "beep:699,250");
				break;
			case R.id.btn_g:
				txtAusgabe = ScompResponseBuilder.buildBasicMsg(lmid, "beep:784,250");
				break;
			case R.id.btn_a:
				txtAusgabe = ScompResponseBuilder.buildBasicMsg(lmid, "beep:880,250");
				break;
			case R.id.button_Connect:
				startBluetooth();
				return;
		}
		
		++zaehler;
		
		try {
			if (mBluetoothScanndyService.getState() == BluetoothScanndyService.STATE_CONNECTED) {
				mBluetoothScanndyService.write(txtAusgabe.getBytes(), true);
				//@@ ConnectToDevice.staticSocket.getInputStream().reset();
			}
		} catch (Exception e) {
		}
	}

	private void setBtConnected(boolean connected) {
		titleBackground.setBackgroundColor(getResources().getColor(connected ? R.color.gruen : R.color.rot));
		titleStatus.setText(getResources().getString(connected ? R.string.connected : R.string.disconnected));
	}
	
	private void appendTextAndScroll(String msg) {
		if (ausgabe != null) {
			String datum = new SimpleDateFormat("dd.MM.yy HH:mm:ss", Locale.getDefault()).format(new Date());
			
	        ausgabe.append(zaehler + ". " + datum + ": " + msg + "\n");
			
			scrollFenster.post(new Runnable() {
				@Override
		        public void run() {
		            scrollFenster.fullScroll(View.FOCUS_DOWN);
		        }
		    });
		}
	}
	
	private void startBluetooth() {
		startActivityForResult(new Intent(this, DeviceListActivity.class), REQUEST_DEVICE);
	}

	public void scompReceive(String payload) {
		appendTextAndScroll(payload);
		++lastMsgId;
	}

    private static class BluetoothHandler extends Handler {
    	
    	private final WeakReference<MainActivity> mActivity;
    	
    	public BluetoothHandler(MainActivity activity) {
    		mActivity = new WeakReference<MainActivity>(activity);
    	}
    	
        @Override
        public void handleMessage(Message msg) {
        	MainActivity activity = mActivity.get(); 
        	if (activity == null)
        		return;
        	
        	switch (msg.what)
        	{
        	case BluetoothScanndyService.MESSAGE_READ:
                try {
                    String scanns = msg.getData().getString(BluetoothScanndyService.SCOMP);
                	ScompSplitter scompMsg = new ScompSplitter(activity, scanns);

                    if (scanns.length() == 18 + scompMsg.getLength() && scompMsg.isCRC32Ok()) {
        				activity.scompReceive(scompMsg.getRawPayload());
						if (scompMsg.getFlag().equals("Q")) {
							activity.mBluetoothScanndyService.write(ScompResponseBuilder.buildOk(scompMsg.getRawMsgId()).getBytes(), true);
						}
        			}
                } catch (Exception e) {
                }
        		break;
        	
        	case BluetoothScanndyService.MESSAGE_STATE_CHANGE:
           		activity.setBtConnected(msg.arg1 == BluetoothScanndyService.STATE_CONNECTED);
				break;
        	}
        }
    };
}
