// KYT3xxxEgView.cpp : implementation of the CKYT3xxxEgView class
//

#include "stdafx.h"
#include "KYT3xxxEg.h"

#include "KYT3xxxEgDoc.h"
#include "KYT3xxxEgView.h"
#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

BYTE * ByteToWord(BYTE by);


/////////////////////////////////////////////////////////////////////////////
// CKYT3xxxEgView

IMPLEMENT_DYNCREATE(CKYT3xxxEgView, CFormView)

BEGIN_MESSAGE_MAP(CKYT3xxxEgView, CFormView)
	//{{AFX_MSG_MAP(CKYT3xxxEgView)
	ON_BN_CLICKED(IDC_BT_IC_CMD, OnBtIcCmd)
	ON_BN_CLICKED(IDC_BT_IC_CMD2, OnBtIcCmd2)
	ON_BN_CLICKED(IDC_BT_MOV, OnBtMov)
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BT_VER, &CKYT3xxxEgView::OnBnClickedBtVer)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CKYT3xxxEgView construction/destruction

CKYT3xxxEgView::CKYT3xxxEgView()
	: CFormView(CKYT3xxxEgView::IDD)
{
	//{{AFX_DATA_INIT(CKYT3xxxEgView)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// TODO: add construction code here

}

CKYT3xxxEgView::~CKYT3xxxEgView()
{
}

void CKYT3xxxEgView::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CKYT3xxxEgView)
	DDX_Control(pDX, IDC_CB_MOV, moCbMov);
	DDX_Control(pDX, IDC_ET_MAIN_VIEW, moEtMainView);
	//}}AFX_DATA_MAP

	GetDlgItem(IDC_BT_IC_CMD)->SetFocus();

moCbMov.AddString(" 30");
moCbMov.AddString(" 31");
moCbMov.AddString(" 32");
moCbMov.AddString(" 33");
moCbMov.AddString(" 34");
moCbMov.AddString(" 35");
moCbMov.AddString(" 36");
	moCbMov.SetCurSel(0);


}

BOOL CKYT3xxxEgView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CFormView::PreCreateWindow(cs);
}

void CKYT3xxxEgView::OnInitialUpdate()
{
	CFormView::OnInitialUpdate();
	GetParentFrame()->RecalcLayout();
	ResizeParentToFit();

}

/////////////////////////////////////////////////////////////////////////////
// CKYT3xxxEgView diagnostics

#ifdef _DEBUG
void CKYT3xxxEgView::AssertValid() const
{
	CFormView::AssertValid();
}

void CKYT3xxxEgView::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}

CKYT3xxxEgDoc* CKYT3xxxEgView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CKYT3xxxEgDoc)));
	return (CKYT3xxxEgDoc*)m_pDocument;
}
#endif //_DEBUG


void proc_event()
{
	MSG at_message;

	if(::PeekMessage(&at_message, NULL, 0, 0, PM_REMOVE)){
		::TranslateMessage(&at_message);
		::DispatchMessage(&at_message);
}	}

//==============================================================
//function	: CString ByteToWord_String2
//input		: BYTE *source	-> ȯȰ ڿ
//			  int size		-> ȯ ڿ 
//output		: none
//return		: CString		-> ȯ ڿ
//dedcryption	:
//	ڿ hex ǥ ascii ڿ ȯ
//	ex) 0x00 0x01 0x30 0xa9 0xb8 0xc7 0xd6 ...
//		-> "[00][01][30][A9][B8][C7][D6]..."
//==============================================================
CString ByteToWord_String2(BYTE *source, int size, byte type)
{//(!). type: 0- default, 5- rf window,
	CString temp;//static CString temp;
	char tmp_str[128]="";

	temp.Empty();
	for(int index = 0; index < size; index++){	
		if(type==5) temp = temp +(CString)ByteToWord(*source++) + " ";
		else temp = temp + "[" + (CString)ByteToWord(*source++) + "]";		
	}	
	return(temp);
}

//==============================================================
//function	: BYTE *ByteToWord
//input		: BYTE byte	-> ȯ 
//output		: none
//return		: BYTE *	-> ȯ ڿ 
//descryption	:
//	Էµ 1BYTE ڸ 2BYTE ڿ ȯ
//	ex) 0xa9 -> "A9"
//		0x88 -> "88"
//==============================================================
BYTE * ByteToWord(BYTE by)
{
static BYTE temp[3];
BYTE ch_high, ch_low;

	memset(temp, 0, sizeof(temp));
	ch_high = by & 0xf0;
	ch_low = by & 0x0f;

	ch_high >>= 4;
	if(ch_high < 10) temp[0] = ch_high | 0x30;
	else temp[0] =  ch_high + 55;
	
	if(ch_low < 10) temp[1] = ch_low | 0x30;
	else temp[1] = ch_low + 55;
	return(temp);
}

CString trim_str(CString ps_str, int pi_trim_len)
{ 
	CString as_res, as_bu;

	as_res.Empty();
	for(; ps_str.GetLength() > pi_trim_len ;){
		as_res+= ps_str.Left(pi_trim_len)+ "\r\n  ";
		as_bu.Empty();
		as_bu= ps_str.Right(ps_str.GetLength()-pi_trim_len);
		ps_str.Empty();
		ps_str= as_bu;
	}
	as_res+= ps_str;

	return as_res;
}

CString dsp_res(BYTE* pba_cmd, BYTE* pba_res, UINT piu_res_len, int pi_errno)
{
	unsigned char aca_errno[10]="";
	CString as_msg;
	CString as_dat;
	BYTE ab_rd_sct_opt=0;//all sector read option-R36
	BYTE ab_str_width= 80,aba_tmp[BUF_SIZ]="";
	unsigned char aca_bal[100]="";
	ULONG alu_n_balance=0, alu_balance=0;
	int ai_view_type=0;

	as_msg.Empty();
	as_dat.Empty();

	//1Line: Command String Display
	CString asTmp;
	asTmp.Format(" COMMAND: %C%C%C",pba_cmd[0] ,pba_cmd[1] ,pba_cmd[2]);
	as_msg= asTmp;

	//2Line: Error Handle
	if(pi_errno)
	{	
		CString asTmp;
		asTmp.Format("0x%02X%02X",pba_res[0],pba_res[1]);
		as_msg =as_msg +  "\r\n RESULT   : False!\r\n ERROR : " + asTmp;//˼ 
	//3Line: Result Display
	}else{				
			as_dat=(CString)"\r\n DATA: " + ByteToWord_String2(pba_res, piu_res_len,0);
			as_msg+= trim_str(as_dat,ab_str_width);
	}
	
	return (as_msg+" ");
}

void wait_res()
{
	CString as_tmp;
	int ai_err_tmp=0;
	BYTE aba_tmp[100]="";
	
	memset(gba_res,0,BUF_SIZ);
	for(;;)
	{
		if(chk_res(gba_stat, gba_res, &giu_res_len, &gb_prc_no, &gi_errno))
		{
			gb_bsy_flg= 0;
			if(gi_errno==2000){
				swab((char*)gba_res, (char*)&ai_err_tmp, 2);
				gi_errno= ai_err_tmp;
			}
			if(gb_prc_no != gb_ret_prc_no) AfxMessageBox("gb_prc_no Error");

			((CKYT3xxxEgView*)((CMainFrame*)AfxGetMainWnd())->GetActiveView())->moEtMainView.SetWindowText(
				dsp_res(gba_cmd, gba_res, giu_res_len, gi_errno)+"   ");

			break;
		}
		proc_event();
}	}

/////////////////////////////////////////////////////////////////////////////
// CKYT3xxxEgView message handlers

void CKYT3xxxEgView::OnBtIcCmd() 
{
	unsigned char aba_tmp[300]="";
	int ai_len= 0;

	aba_tmp[0]= 0;
	aba_tmp[1]= 14;
	ai_len=aba_tmp[1]+2;

	memcpy(&aba_tmp[2], "\x00\xA4\x04\x00\x08\xA0\x00\x00\x00\x03\x00\x00\x00\x00", 14);	
	
	memcpy(gba_cmd,"C65",3);
	if(gb_ret_prc_no= exe_cmd(gba_cmd, aba_tmp, ai_len)) wait_res();
	else AfxMessageBox("Frame Error");	
}


//======================================================================
// $. com_setup()
//		- serial port setup
//
// * Last Update:	
// * PROTOTYPE 
//		- int CCom::com_setup(int flag)
//	* PARAMETERS
//		- flag
//			0 :	ʱȭ ȣ
//			1 :	Dialog Box  Setup
//	* RETURN
//		- 	: 1
//		- ERROR	: 0
//	* DETAIL
//		- 
//======================================================================
int com_set(BYTE ab_flag, port pt_port)
{
	FILE *stream;
	char temp[100]="";
	char aca_port_name[10]="";
	ULONG alu_baud_rate=0;


			pt_port.name=0;
			pt_port.baud_rate="19200";
			pt_port.data=8;
			pt_port.stop = pt_port.parity = pt_port.method = 0;


	DisablePort();//Thread Բ ؾ
	Sleep(100);

	memcpy(aca_port_name,"COM3",4);

	alu_baud_rate=19200;	

	//EnablePort( "COM1", 8, 0, 0, 9600, 0);
	if(EnablePort(aca_port_name, pt_port.data, pt_port.parity, pt_port.stop, alu_baud_rate, pt_port.method)){
		stream = fopen("Port.cfg", "w+");
		fprintf(stream, "PORT: %d\r\nBAUDRATE: %s\r\nDATA_BIT: %d\r\nSTOP_BIT: %d\r\nPARITY_BIT: %d\r\nCONTROL: %d",
		  pt_port.name, pt_port.baud_rate, pt_port.data, pt_port.stop, pt_port.parity, pt_port.method);
		fclose(stream);	
	}else{
		AfxMessageBox("Serial port setup error!\r\n\r\nPlease Check and Try again!", MB_OK, MB_ICONEXCLAMATION);
		return 0;
	}

	return 1;
}

void CKYT3xxxEgView::OnBtIcCmd2() 
{
	unsigned char aba_tmp[300]="";
	int ai_len= 0;

	aba_tmp[0]= 0;
	aba_tmp[1]= 14;
	ai_len=aba_tmp[1]+2;
	
	memcpy(&aba_tmp[2], "\x80\x50\x00\x00\x08\x01\x02\x03\x04\x05\x06\x07\x08\x00", 14);	
	
	memcpy(gba_cmd,"C65",3);
	if(gb_ret_prc_no= exe_cmd(gba_cmd, aba_tmp, ai_len)) wait_res();
	else AfxMessageBox("Frame Error");		
}

void CKYT3xxxEgView::OnBtMov() 
{
	unsigned char aba_tmp[300]="";
	int ai_len= 0;

	aba_tmp[0]= 0;
	aba_tmp[1]= 14;
	ai_len=aba_tmp[1]+2;
	
moCbMov.GetCurSel();
	
	memcpy(gba_cmd,"C0",2);
	gba_cmd[2]= '0' + moCbMov.GetCurSel();
	if(gb_ret_prc_no= exe_cmd(gba_cmd, aba_tmp, 0)) wait_res();
	else AfxMessageBox("Frame Error");		
}


void CKYT3xxxEgView::OnBnClickedBtVer()
{
	unsigned char aba_tmp[300]="";
		
	memcpy(gba_cmd,"C11",3);
	if(gb_ret_prc_no= exe_cmd(gba_cmd, aba_tmp, 0)) wait_res();
	else AfxMessageBox("Frame Error");	
}
